#include "mbed.h" /*Include standard mbed library*/
#include "XBee.h" /*Include library for XBee transmitter/reciever*/
#include "LM75B.h" /*Include library for temperature sensor*/
#include "C12832A1Z.h" /*Include library for LCD display*/

Serial xbee1(p9,p10); /*Declare XBee transmit/receive as pins 9 and 10*/
DigitalOut rst1(p30); /*Declare pin 29 as the reset pin for the XBee*/
LM75B temp(p28,p27); /*Declare temperature sensor transmit/recieve as pins 27 and 28*/
DigitalOut red(p23); /*Declare pin 23 as the red LED*/
DigitalOut green(p24); /*Declare pin 24 as the green LED*/
DigitalOut blue(p25); /*Declare pin 25 as the blue LED*/
DigitalOut relay(p8); /*Declare pin 8 as the output to an external relay*/

C12832A1Z lcd(p5, p7, p6, p8, p11); /*Set pins for LCD display (MOSI, SCK, Reset, A0 and nCS)*/

int main() { /*Start of main function*/
    rst1 = 0; /*Set XBee reset pin to 0*/
    wait_ms(1); /*Wait 1 millisecond*/
    rst1 = 1; /*Set XBee reset pin to 1*/
    wait_ms(1); /*Wait 1 millisecond*/
    
    lcd.locate(20,0); /*Locate the area to print in on the LCD*/
    lcd.printf("Battery Temperature"); /*Output to LCD screen at position 20,0*/
    lcd.locate(18,10); /*Locate the area to print in on the LCD*/
    lcd.printf("Monitoring - DMOS B"); /*Output to LCD screen at position 18,10*/
    lcd.locate(15,20); /*Locate the area to print in on the LCD*/
    lcd.printf("(C) D.Fitzgerald - 2016"); /*Output to the LCD screen at position 15,20*/
    wait(5); /*Wait 5 seconds (displays the above message for 5 seconds*/
    lcd.cls(); /*Clear all messages from LCD screen*/

    int a; /*Declare 'a' as an integer value*/
    int b; /*Declare 'b' as an integer value*/
    int c; /*Declare 'c' as an integer value*/
    int d; /*Declare 'd' as an integer value*/
    
    lcd.locate(6,0); /*Locate the area to print on the LCD*/
    lcd.printf("DMOS A Batteries = "); /*Output to LCD screen at position 6,0*/
    lcd.locate(6,16); /*Locate the area to print on the LCD*/
    lcd.printf("DMOS B Batteries = "); /*Output to LCD screen at position 6,16*/
    
    d=1; /*Set value of 'd' to be '1' permanently*/

    while (d>0) { /*Infinite while loop whilst d is greater than 0, which is always*/
            /*The three LED's must be 'logically notted' in order to force them off before use*/
            green=!green; /*Logically not the green LED*/
            red=!red; /*Logically not the red LED*/
            blue=!blue; /*Logically not the blue LED (not used but still needs to be turned off to prevent mixing with other colours*/
            b = temp.read(); /*Read the temperature from the LM75 temperature sensor*/
            /*XBee devices are capable of duplex communications, which is utilised in the next two steps*/
            xbee1.putc(b); /*Put the read temperature into the XBee output port*/
            a = xbee1.getc(); /*Retrieve the temperature that is being sent from the other ARM MBED device from the XBee*/
            lcd.locate(100,0); /*Locate the area to print the temperature to on the LCD screen*/ 
            lcd.printf("%d C\n",a); /*Print the temperature from the other ARM MBED device at location 100,0*/
            lcd.locate(100,16); /*Locate the area to print the temperature to on the LCD screen*/
            lcd.printf("%d C\n",b); /*Print the temperature from the local ARM MBED device at location 100,16*/
            wait_us(10); /*Wait 10 microseconds*/
            c = abs(a-b); /*Subtract the local temperature from the remote temperature and create this as an absolute (positive) only value*/
                if(c<3){ /*Start of If loop for if the temperature difference calculated in the previous step is equal to or less than 3 degrees*/
                /*The LED's have to be forced off to prevent the RGB LED mixing it's colours*/
                green=1; /*Turn the green LED on*/
                red=0; /*Force the red LED off*/
                blue=0; /*Force the blue LED off*/
                } /*End of If loop*/
                else{ /*If the temperature difference calculated as 'c' is anything other than the parameter set in the previous if loop, do the following...*/
                red=1; /*Turn the red LED on*/
                green=0; /*Force the green LED off*/
                blue=0; /*Force the blue LED off*/
                relay=1; /*Apply a logic value of '1' to pin 8, to activate an external relay in order to turn off battery charging supply*/
                } /*End of If loop*/
            } /*End of infinite while loop*/
} /*End of main function*/