#include "mbed.h" /*Include standard mbed library*/
#include "XBee.h" /*Include library for XBee transmitter/reciever*/
#include "C12832.h" /*Include library for temperature sensor*/
#include "LM75B.h" /*Include library for LCD display*/
#include "SDFileSystem.h" /*Include library for SD card read/write*/

Serial xbee1(D1,D0); /*Declare XBee transmit/receive as pins 1 and 0*/
DigitalOut rst1(D3); /*Declare pin 3 as the reset pin for the XBee*/
LM75B temp(PTE25,PTE24); /*Declare temperature sensor transmit/recieve as pins 24 and 25*/
DigitalOut red(PTB22); /*Declare pin 22 as the red LED*/
DigitalOut green(PTE26); /*Declare pin 26 as the green LED*/
DigitalOut blue(PTB21); /*Declare pin 21 as the blue LED*/
DigitalOut relay(D4); /*Declare pin 4 as the output to an external relay*/

C12832 lcd(D11, D13, D12, D7, D10); /*Assign pins for LCD display (MOSI, SCK, Reset, A0 and nCS)*/
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd"); /*Assign pins for SD card us (MOSI, MISO, sclk and cs*/

int main() { /*Start of main function*/
    rst1 = 0; /*Set XBee reset pin to 0*/
    wait_ms(1); /*Wait 1 millisecond*/
    rst1 = 1; /*Set XBee reset pin to 1*/
    wait_ms(1); /*Wait 1 millisecond*/
    FILE *File = fopen("/sd/BTLDirectory.txt", "w"); /*Open file*/
    

    lcd.locate(20,0); /*Locate the area to print in on the LCD*/
    lcd.printf("Battery Temperature"); /*Output to LCD screen at position 20,0*/
    lcd.locate(18,10); /*Locate the area to print in on the LCD*/
    lcd.printf("Monitoring - DMOS A"); /*Output to LCD screen at position 18,10*/
    lcd.locate(15,20); /*Locate the area to print in on the LCD*/
    lcd.printf("(C) D.Fitzgerald - 2016"); /*Output to the LCD screen at position 15,20*/
    wait(5); /*Wait 5 seconds (displays the above message for 5 seconds*/
    lcd.cls(); /*Clear all messages from LCD screen*/

    int a; /*Declare 'a' as an integer value*/
    int b; /*Declare 'b' as an integer value*/
    int c; /*Declare 'c' as an integer value*/
    int d; /*Declare 'd' as an integer value*/
    
    lcd.locate(6,0); /*Locate the area to print on the LCD*/
    lcd.printf("DMOS A Batteries = "); /*Output to LCD screen at position 6,0*/
    lcd.locate(6,16); /*Locate the area to print on the LCD*/
    lcd.printf("DMOS B Batteries = "); /*Output to LCD screen at position 6,16*/

    d=1; /*Set value of 'd' to be '1' permanently*/
    
    while (d>0) { /*Infinite while loop whilst d is greater than 0, which is always*/
            /*The three LED's must be 'logically notted' in order to force them off before use*/
            green=!green; /*Logically not the green LED*/
            red=!red; /*Logically not the red LED*/
            blue=!blue; /*Logically not the blue LED (not used but still needs to be turned off to prevent mixing with other colours*/
            a = temp.read(); /*Read the temperature from the LM75 temperature sensor*/
            /*XBee devices are capable of duplex communications, which is utilised in the next two steps*/
            xbee1.putc(a); /*Put the read temperature into the XBee output port*/
            b = xbee1.getc(); /*Retrieve the temperature that is being sent from the other ARM MBED device from the XBee*/
            lcd.locate(100,0); /*Locate the area to print the temperature to on the LCD screen*/ 
            lcd.printf("%d C\n",a); /*Print the temperature from the other ARM MBED device at location 100,0*/
            lcd.locate(100,16); /*Locate the area to print the temperature to on the LCD screen*/
            lcd.printf("%d C\n",b); /*Print the temperature from the local ARM MBED device at location 100,16*/
            wait_us(10); /*Wait 10 microseconds*/
            c = abs(a-b); /*Subtract the local temperature from the remote temperature and create this as an absolute (positive) only value*/
                if(c<3){ /*Start of If loop for if the temperature difference calculated in the previous step is equal to or less than 3 degrees*/
                /*The LED's have to be forced off to prevent the RGB LED mixing it's colours*/
                green=1; /*Turn the green LED on*/
                blue=0; /*Force the red LED off*/
                red=0; /*Force the blue LED off*/
                } /*End of If loop*/
                else{ /*If the temperature difference calculated as 'c' is anything other than the parameter set in the previous if loop, do the following...*/
                red=1; /*Turn the red LED on*/
                green=0; /*Force the green LED off*/
                blue=0; /*Force the blue LED off*/
                relay=1; /*Apply a logic value of '1' to pin 8, to activate an external relay in order to turn off battery charging supply*/
                fprintf(File, "The battery box temperatures on this train have differed by\nat least 3 degrees during the course of the day"); /*Store number of events to SD Card*/
                fclose(File); /*Close SD Card File*/
                } /*End of If loop*/
            } /*End of infinite while loop*/
} /*End of main function*/