#ifndef TCP_ECHO_HANDLER_H
#define TCP_ECHO_HANDLER_H

#include "mbed.h"
#include "TCPSocket.h"

// Constant: ECHO_TIMOUT
// The timeout period for inactivity in milliseconds
#define ECHO_TIMEOUT 5000

/*
    Class: TCPEchoHandler
    A class instantiated to handle the incoming TCP client connection
    Extends NetService to hook into the TCP/IP stack's polling
    and destruction service
*/
class TCPEchoHandler : public NetService {
public:
    // Constructor: TCPEchoHandler
    // Setup and handle the incoming connection
    TCPEchoHandler(TCPSocket*);
    virtual ~TCPEchoHandler();
private:
    // Variable: clientSocket
    // The incoming TCP socket from the client
    TCPSocket* clientSocket;
    // Variable: closed
    // A marker to say whether this socket is already closed
    int closed;
    // Variable: timeoutWatchdog
    // A timer to countdown from during inactivity and close
    // dormant connections
    Timeout timeoutWatchdog;

    // Function: onNetTcpSocketEvent
    // The callback function called by the network stack whenever an
    // event occurs on the TCP socket
    // Parameter: e - The event that has occurred
    void onTCPSocketEvent(TCPSocketEvent e);
    // Function: close
    // Closes the client socket and marks this class as done with
    // for the TCP/IP stack to destroy
    virtual void close();
    // Function: setTimeout
    // Parameter: timeout - The length of time to wait for more activity in milliseconds
    void setTimeout(unsigned int timeout);
    // Function: onTimeout
    // The handler called by the timeout watchdog to close the connection when timed out
    void onTimeout();
};

#endif
