#include "mbed.h"
#include "EthernetNetIf.h"

DigitalOut myled(LED1);

EthernetNetIf eth;

int main() {
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup on DHCP.\r\n", ethErr);
        return -1;
    }
    printf("Trying to get IP address\r\n");
    IpAddr ip = eth.getIp();
    printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);

    printf("Entering while loop Net::poll()ing\r\n");
    while (1) {
        Net::poll();
    }
}
