/*
 * Auto Discovery
 * Broadcasts information about this mbed on port 2010
 * Enables other devices on the same network to find it
 */

#define LWIP_NETIF_HOSTNAME "mbed_dms"

#include "mbed.h"
#include "EthernetNetIf.h"

#include "AutoDiscoveryBroadcaster.h"

// Our Ethernet interface
EthernetNetIf eth;
// Static IP address information
/*
EthernetNetIf eth(
  IpAddr(192,168,1,158), //IP Address
  IpAddr(255,255,255,0), //Network Mask
  IpAddr(192,168,1,254), //Gateway
  IpAddr(192,168,1,2)    //DNS
);
*/
// Our AutoDiscoveryBroadcaster server
AutoDiscoveryBroadcaster adb;

/*
    Function: main
    
    Sets up the Ethernet interface using DHCP, sets
    up the AutoDiscoveryBroadcaster which then
    fires out UDP datagrams with info about the mbed
*/
int main() {

    printf("\r\nSetting up...\r\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup on DHCP.\r\n", ethErr);
        return -1;
    }
    printf("Trying to get IP address\r\n");
    IpAddr ip = eth.getIp();
    printf("mbed IP Address is %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);

    adb.start();

    printf("Entering while loop Net::poll()ing\r\n");
    while (1) {
        Net::poll();
    }
}
