#ifndef AUTO_DISCOVERY_BROADCASTER_H
#define AUTO_DISCOVERY_BROADCASTER_H

#include "mbed.h"
#include "UDPSocket.h"
#include "BroadcastMessage.h"

/*
    Class: AutoDiscoveryBroadcaster
    Periodically sends out hostname
    and IP address on UDP port 2010
*/
class AutoDiscoveryBroadcaster {
public:
    // Constructor: AutoDiscoveryBroadcaster
    // Creates the UDP sockets
    AutoDiscoveryBroadcaster();
    // Destructor: ~AutoDiscoveryBroadcaster
    // Deletes the UDP socket
    ~AutoDiscoveryBroadcaster();
    /*
        Function: start
        Starts periodically sending out the information datagrams
        Parameters:
            udpPort - The UDP port to send on (default 2010)
            period  - The period between broadcasts
     */
    void start(int udpPort=2010, int period=5);
    /*
        Function: stop
        Stops sending out the information datagrams
     */
    void stop();
private:
    // Variable: udpSock
    // The UDP socket
    UDPSocket* udpSock;
    // Variable: running
    // Flag to indicate whether we're running or not
    char running;
    // Variable: ticker
    // Ticker used to periodically call broadcast()
    Ticker ticker;
    Host host;
    
    // Function: broadcast
    // The method that actually broadcasts the information
    // about this mbed
    void broadcast();
    
    BroadcastMessage msg;
};

#endif
