#include "AutoDiscoveryBroadcaster.h"

AutoDiscoveryBroadcaster::AutoDiscoveryBroadcaster() {
    running = 0;
    // Create the UDP socket
    udpSock = new UDPSocket;
}

AutoDiscoveryBroadcaster::~AutoDiscoveryBroadcaster() {
    stop();
    udpSock->close();
    // Delete the UDP socket
    delete udpSock;
}

void AutoDiscoveryBroadcaster::start(int udpPort, int period) {
    if ( !running ) {
        msg.init();
        udpSock->bind(Host(IP_ADDR_ANY, udpPort));
        host = Host(IP_ADDR_BROADCAST, udpPort);
        //host = Host(IpAddr(192,168,1,141), udpPort);
        ticker.attach(this, &AutoDiscoveryBroadcaster::broadcast, period);
        running = 1;
        // call once now
        broadcast();
    }
}

void AutoDiscoveryBroadcaster::stop() {
    if ( running ) {
        ticker.detach();
        running = 0;
    }
}

void AutoDiscoveryBroadcaster::broadcast() {
    printf("Sending result = %d\r\n", udpSock->sendto(msg.getBytes(), msg.getLength(), &host));
}
