#ifndef BROADCAST_MESSAGE_H
#define BROADCAST_MESSAGE_H

#include "mbed.h"
#include "UDPSocket.h"

/*
    Class: AutoDiscoveryBroadcaster
    Periodically sends out hostname
    and IP address on UDP port 2010
*/
class BroadcastMessage {
public:
    // Constructor: AutoDiscoveryBroadcaster
    // Creates the UDP sockets
    BroadcastMessage();
    // Destructor: ~AutoDiscoveryBroadcaster
    // Deletes the UDP socket
    ~BroadcastMessage();
    void init();
    // Function: getBytes
    // Returns the message to transmit
    char* getBytes();
    int getLength();
private:
    char buff[1024];
    int len;
};
 
#endif
 