#include "mbed.h"
#include "freetronicsLCDShield.h"
freetronicsLCDShield LCD(D0,D1,D2,D3,D4,D5,D6,A0);  //Definir Pines

const char CGRAM_DATA[32]= {0x00,0x0E,0x0A,0x0E,0x04,0x0E,0x04,0x08,    //Caracter pierna izquierda de personaje
                            0x00,0x0E,0x0A,0x0E,0x04,0x0E,0x04,0x02,    //Caracter pierna derecha de personaje
                            0x00,0x00,0x00,0x00,0x00,0x04,0x0E,0x1F,    //Caracter o obstaculo #1
                            0x00,0x00,0x00,0x04,0x0A,0x15,0x0E,0x1F     //Caracter o obstaculo #2
                           };

InterruptIn int1(D8);       //Boton salto
InterruptIn int2(D9);      //Boton Reinicio
Timer t;                  //Duracion
Ticker hora;              //Puntuacion
int n = 0;
int p,d,q=0,s=16,s1=11,h=0,z=0,w=0; //Variables a usar en el programa

void ISR_pin6()         //Funcion del boton
{
    if(s>=0 && s<=2) {

        LCD.setCursorPosition(0,0);
        LCD.putc(0);                    //Saltos
        LCD.setCursorPosition(1,0);
        LCD.printf(" ");

        LCD.setCursorPosition(1,s);
        LCD.putc(2);                   //Animacion del salto con bloque abajo
        LCD.setCursorPosition(1,s+1);
        LCD.printf(" ");

        wait(1);
        LCD.setCursorPosition(1,0);
        LCD.putc(0);                //Animacion Cuando esta abajo
        LCD.setCursorPosition(0,0);
        LCD.printf(" ");

        wait(1);
        LCD.cls();
        LCD.setCursorPosition(1,0);
        LCD.putc(0);
        h=1;

    } else if(s1>=-5 && s1<=-3) {

        LCD.setCursorPosition(0,0);
        LCD.putc(0);
        LCD.setCursorPosition(1,0);
        LCD.printf(" ");

        LCD.setCursorPosition(1,s1+5);
        LCD.putc(3);
        LCD.setCursorPosition(1,s1+6);
        LCD.printf(" ");

        wait(1);

        LCD.setCursorPosition(1,0);
        LCD.putc(0);
        LCD.setCursorPosition(0,0);
        LCD.printf(" ");
        wait(1);
        LCD.cls();
        LCD.setCursorPosition(1,0);
        LCD.putc(0);
        h=1;

    } else {

        LCD.setCursorPosition(0,0);
        LCD.putc(0);
        LCD.setCursorPosition(1,0);
        LCD.printf(" ");
        wait(1);
        LCD.setCursorPosition(1,0);
        LCD.putc(0);
        LCD.setCursorPosition(0,0);
        LCD.printf(" ");
        wait(1);
        LCD.setCursorPosition(1,0);
        LCD.putc(0);

    }
}
void crono()                //Funcion marcador de puntuacion
{
    if(w==0) {
        if(q == 1) {
            LCD.setCursorPosition(0,11);
            LCD.printf(" %d ",d);
            d=d+1;
        }
        if( (z%2) == 0 ) {
            z=1;
        } else {
            z=0;
        }
    }
}
void reset()            //Despues del game over reinicia juego todo en 0
{
    w=0;
}
int main()
{
    d=0;
    int1.mode(PullUp);
    int1.rise(&ISR_pin6);
    int2.mode(PullUp);
    int2.rise(&reset);
    hora.attach(&crono,1);
    LCD.writeCGRAM (0x00, &CGRAM_DATA[0], 8);
    LCD.writeCGRAM (0x08, &CGRAM_DATA[8], 8);   //llamado de mis animaciones
    LCD.writeCGRAM (0x10, &CGRAM_DATA[16], 8);
    LCD.writeCGRAM (0x18, &CGRAM_DATA[24], 8);
    LCD.cls();
    LCD.setBackLight(false);
    wait(2.0);
    LCD.setBackLight((float) 0.7);
    LCD.cls();
    LCD.setCursorPosition (0,2);
    LCD.setCursor(false);
    LCD.putc('U');
    wait(0.5);
    LCD.putc('N');
    wait(0.5);
    LCD.putc('I');
    wait(0.5);
    LCD.putc('V');
    wait(0.5);
    LCD.putc('E');                      //Banner
    wait(0.5);
    LCD.putc('R');
    wait(0.5);
    LCD.putc('S');
    wait(0.5);
    LCD.putc('I');
    wait(0.5);
    LCD.putc('D');
    wait(0.5);
    LCD.putc('A');
    wait(0.5);
    LCD.putc('D');
    wait(0.5);
    LCD.setCursorPosition (1,4);
    LCD.setCursor(false);
    LCD.putc('D');
    wait(0.5);
    LCD.putc('I');
    wait(0.5);
    LCD.putc('S');
    wait(0.5);
    LCD.putc('T');
    wait(0.5);
    LCD.putc('R');
    wait(0.5);
    LCD.putc('I');
    wait(0.5);
    LCD.putc('T');
    wait(0.5);
    LCD.putc('A');
    wait(0.5);
    LCD.putc('L');
    wait(0.5);
    LCD.cls();
    q=1;
    LCD.setCursorPosition(1,0);
    LCD.putc(0);

    while(true) {
        if(w==0) {
            if(h==0) {
                LCD.setCursorPosition(1,0);
                LCD.putc(z);

                LCD.setCursorPosition(0,4);
                LCD.printf("level %d", (d/10));
                //Juego en movimiento con la animacion y obstaculos
                LCD.setCursorPosition(1,s);
                LCD.putc(2);
                LCD.setCursorPosition(1,s+1);
                LCD.printf(" ");

                LCD.setCursorPosition(1,s1+5);
                LCD.putc(3);
                LCD.setCursorPosition(1,s1+6);
                LCD.printf(" ");
                if(s1==-5 || s==0) {
                    LCD.cls();
                    w=1;
                }

            } else {                //Si toca el bloque el personaje

                h=0;
                LCD.setCursorPosition(1,0);
                LCD.putc(z);
            }

            LCD.setCursorPosition(1,0);
            LCD.putc(z);


            if(s1<-5) {
                s1=16;
            }
            if(s<0) {
                s=16;
            }
            s--;
            s1--;
            wait(0.7);

        } else {                            //Visualiza el GAME OVER
            LCD.cls();
            LCD.setCursorPosition (0,4);
            LCD.setCursor(false);
            LCD.putc('G');
            wait(0.5);
            LCD.putc('A');
            wait(0.5);
            LCD.putc('M');
            wait(0.5);
            LCD.putc('E');
            wait(0.5);
            LCD.putc(' ');
            wait(0.5);
            LCD.putc('O');
            wait(0.5);
            LCD.putc('V');
            wait(0.5);
            LCD.putc('E');
            wait(0.5);
            LCD.putc('R');
            wait(0.5);
            LCD.cls();
            s=16;
            s1=11;
            d=0;
        }
    }

}



