#include "MMA8451Q.h"
#include "mbed.h"

#if defined(TARGET_KL25Z) || defined(TARGET_KL46Z)
PinName const SDA = PTE25;
PinName const SCL = PTE24;          //pines acelerometro
#elif defined(TARGET_KL05Z)
PinName const SDA = PTB4;
PinName const SCL = PTB3;
#elif defined(TARGET_K20D50M)
PinName const SDA = PTB1;
PinName const SCL = PTB0;
#else
#error TARGET NOT DEFINED
#endif
#define MMA8451_I2C_ADDRESS (0x1d << 1)
I2CSlave slave(PTE0, PTE1);
MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
PwmOut rled(D3);
PwmOut gled(D4);
PwmOut bled(D5);
Serial pc(USBTX, USBRX); 

DigitalOut led1(LED2);

float datos()
{
    float x, y, z;
    x = abs(acc.getAccX());
    y = abs(acc.getAccY());
    z = abs(acc.getAccZ());
    rled = 1.0f - x;
    gled = 1.0f - y;
    bled = 1.0f - z;
    wait_us(100000);
    return y;
    // printf("X: %f, Y: %f, Z: %f\n", x,y,z);
}
int main(void)
{
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
    PwmOut rled(D3);
    PwmOut gled(D4);
    PwmOut bled(D5);
    char buf[13];       //recibir datos para guardar en un buffer
    printf("MMA8451 ID: %d\n", acc.getWhoAmI());        //identifica que el sensor esta en funcionamiento en serial
    slave.address(0xA0);        //10100000
    while (true) {
// 10 0111  110 0100
        int i = slave.receive();
        switch (i) {
            case I2CSlave::WriteAddressed:
                slave.read(buf, 13);
                // sprintf(buf, "%f\n", datos);
                float x, y, z;                      //enviar datos de acelerometro
                x = abs(acc.getAccX());
                y = abs(acc.getAccY());
                z = abs(acc.getAccZ());
                sprintf(buf,"%f%f%f\n",x,y,z);
                pc.printf("%f%f%f\n",x,y,z);
                
                printf("%s\n", buf);
                slave.write(buf, 13);
                led1 = !led1;
                break;                      //rompe el ciclo y reinicia el buffer
        }
        
        for (int i = 0; i < 10; i++) {
            buf[i] = 0; // Clear buffer
        }
    }
}
