#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "button_group.hpp"
#include "Adafruit_APDS9960.h"

Serial pc(USBTX, USBRX); // tx, rx

I2C * i2c_sensor;
Adafruit_APDS9960 *sensor;

using namespace Mikami;
TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;


void init_sensor()
{
    i2c_sensor = new I2C(I2C_SDA, I2C_SCL);
    sensor = new Adafruit_APDS9960(&pc);
    bool initok = sensor->begin(i2c_sensor);
    if (!initok)
    {
        pc.printf("\n\rErreur avec l'initialisation du capteur de couleur\n\r");
    }else pc.printf("\n\rLe capteur de couleur a ete initialise\n\r");
    sensor->enableColor(true);
}


int main()
{
    init_sensor();
    
    unsigned int boutton_commencer = 0;
    unsigned int boutton_reset = 0;
    
    unsigned int nbAlea = 0;
    unsigned int couleur;
    unsigned int couleur1;
    unsigned int couleur2;
    unsigned int couleur3;
    unsigned int couleur4;
    unsigned int sequence = 0;
    unsigned int i = 0;
    
    unsigned int reponse;
    unsigned int reponse1;
    unsigned int reponse2;
    unsigned int reponse3;
    unsigned int reponse4;
    unsigned int sequence_reponse = 0;
    unsigned int j = 0;
    
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
 
 
    while(1)
    {      
        //Ecran d'acceuil
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    
        BSP_LCD_DisplayStringAt(0, 40, (uint8_t *)"BIENVENUE", CENTER_MODE);
        HAL_Delay(2000);
        
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_RED);
        BSP_LCD_DisplayStringAt(0, 90, (uint8_t *)"SUR UN", CENTER_MODE);
        HAL_Delay(2000);
    
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, 140, (uint8_t *)"CAPTEUR DE COULEUR", CENTER_MODE);
        HAL_Delay(2000);
        
        
        //Bouton commencer la partie
        Button commencer(lcd_, ts_, 88, 205, 300, 50,
                     LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Commencer la partie", Font20);
        commencer.Draw(LCD_COLOR_WHITE, LCD_COLOR_BLACK);
        
        while(boutton_commencer == 0)
        {    
            if(commencer.Touched())
            {
                boutton_commencer = 1;
            }
        }
        boutton_commencer = 0;
        
        
        //Ecran montrant la séquence à répéter pour gagner
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
        BSP_LCD_DisplayStringAt(0, 40, (uint8_t *)"Repeter la sequence", CENTER_MODE);
        BSP_LCD_SetTextColor(LCD_COLOR_RED);
        BSP_LCD_DisplayStringAt(0, 80, (uint8_t *)"une fois celle-ci", CENTER_MODE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)"terminee", CENTER_MODE);
        HAL_Delay(4000);
     
     
        //Initialisation de la séquence 
        while(sequence == 0){
            srand(time(NULL));  
            nbAlea=rand()%4;
            //nbAlea=rand()%3;
            
            switch(nbAlea){
                case 0:
                    couleur = LCD_COLOR_RED;
                    i = i + 1;
                    break;
                case 1:
                    couleur = LCD_COLOR_GREEN;  
                    i = i + 1;
                    break;
                case 2:
                    couleur = LCD_COLOR_BLUE;
                    i = i + 1;
                    break;
                case 3:   
                    couleur = LCD_COLOR_WHITE;
                    i = i + 1;
                    break;
            }  
            
            switch(i){
                case 1:
                    couleur1 = couleur;
                    BSP_LCD_SetTextColor(couleur1);
                    BSP_LCD_FillRect(50, 170, 70, 70);
                    HAL_Delay(1000);
                    break;
                case 2:
                    couleur2 = couleur;
                    BSP_LCD_SetTextColor(couleur2);
                    BSP_LCD_FillRect(150, 170, 70, 70);
                    HAL_Delay(1000);
                    break;
                case 3:
                    couleur3 = couleur;   
                    BSP_LCD_SetTextColor(couleur3);
                    BSP_LCD_FillRect(250, 170, 70, 70);
                    HAL_Delay(1000);
                    break;
                case 4:   
                    couleur4 = couleur;   
                    BSP_LCD_SetTextColor(couleur4);
                    BSP_LCD_FillRect(350, 170, 70, 70);
                    HAL_Delay(1000);
                    sequence = 1;
                    i = 0;
                    break;
            }
            wait_us(2000000);
        }
        sequence = 0;
        
        
        //Ecran "tour de l'utilisateur"
        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
        BSP_LCD_DisplayStringAt(0, 40, (uint8_t *)"A vous de jouer !", CENTER_MODE);
        BSP_LCD_SetTextColor(LCD_COLOR_RED);
        BSP_LCD_DisplayStringAt(0, 80, (uint8_t *)"Quelle etait la sequence ?", CENTER_MODE);
        //BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        //BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)"Appuyer sur le bouton de couleur correspondant", CENTER_MODE);
        HAL_Delay(4000);
        
            
        //create some variables to store the color data in
        uint16_t r, g, b, c;
            
        //wait for color data to be ready
        while(!sensor->colorDataReady()){
        wait_us(5000);
        }
        
        while(sequence_reponse == 0){
            //get the data and print the different channels
            sensor->getColorData(&r, &g, &b, &c);
            pc.printf("red: ");
            pc.printf("%u ", r);
            
            pc.printf(" green: ");
            pc.printf("%u ", g);
            
            pc.printf(" blue: ");
            pc.printf("%u ", b);
            
            pc.printf(" clear: ");
            pc.printf("%u ", c);
            pc.printf("\r\n");
        
            if(r>400 && g>400 && b>400)
            {
                pc.printf("Test 0: blanc\r\n");
                reponse = LCD_COLOR_WHITE;
                j = j + 1;
            }
            else if(r>g && r>b && r>100)
            {
                pc.printf("Test 1: rouge\r\n");
                reponse = LCD_COLOR_RED;
                j = j + 1;
            }
            else if(b>r && b>g && b>100)
            {
                pc.printf("Test 2: bleu\r\n");
                reponse = LCD_COLOR_BLUE;
                j = j + 1;
            }
            else if(g>r && g>b && g>100)
            {
                pc.printf("Test 3: vert\r\n");
                reponse = LCD_COLOR_GREEN;
                j = j + 1;
            }
            
            switch(j){
                case 1:
                    reponse1 = reponse;
                    BSP_LCD_SetTextColor(reponse1);
                    BSP_LCD_FillRect(50, 170, 70, 70);
                    HAL_Delay(1000);
                    break;
                case 2:
                    reponse2 = reponse;
                    BSP_LCD_SetTextColor(reponse2);
                    BSP_LCD_FillRect(150, 170, 70, 70);
                    HAL_Delay(1000);
                    break;
                case 3:
                    reponse3 = reponse;   
                    BSP_LCD_SetTextColor(reponse3);
                    BSP_LCD_FillRect(250, 170, 70, 70);
                    HAL_Delay(1000);
                    break;
                case 4:   
                    reponse4 = reponse;   
                    BSP_LCD_SetTextColor(reponse4);
                    BSP_LCD_FillRect(350, 170, 70, 70);
                    HAL_Delay(1000);
                    sequence_reponse = 1;
                    j = 0;
                    break;
            }          
            wait_us(1000000);
        }
        sequence_reponse = 0;
        
        if(couleur1==reponse1 && couleur2==reponse2 && couleur3==reponse3 && couleur4==reponse4)
        {
            BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
            BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)"VOUS AVEZ GAGNE", CENTER_MODE);
        }
        else
        {
            BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
            BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)"VOUS AVEZ PERDU", CENTER_MODE);    
        }
        
        
        //Bouton rejouer la partie       
        Button reset(lcd_, ts_, 410, 5, 60, 40,
                     LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Rejouer", Font12);
        reset.Draw(LCD_COLOR_WHITE, LCD_COLOR_BLACK);
        
        while(boutton_reset == 0)
        {    
            if(reset.Touched())
            {
                boutton_reset = 1;
            }
        }
        boutton_reset = 0;
    }
}
