#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "button_group.hpp"
#include "pomme.h"
#include "poire.h"
#include "orange.h"
#include "banane.h"
#include "tomate.h"
#include "fraise.h"
#include "raisin.h"
#include "kiwi.h"
#include "haricot.h"


Serial pc(USBTX, USBRX); // tx, rx
Serial bt(PC_6, PC_7);

using namespace Mikami;
TS_DISCO_F746NG ts_;
LCD_DISCO_F746NG lcd_;


//Pomme
void drawImage_pomme(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)pomme.data;
    while(y < pomme.height) {
        while(x < pomme.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}


//Poire
void drawImage_poire(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)poire.data;
    while(y < poire.height) {
        while(x < poire.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Orange
void drawImage_orange(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)orange.data;
    while(y < orange.height) {
        while(x < orange.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Banane
void drawImage_banane(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)banane.data;
    while(y < banane.height) {
        while(x < banane.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Tomate
void drawImage_tomate(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)tomate.data;
    while(y < tomate.height) {
        while(x < tomate.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Fraise
void drawImage_fraise(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)fraise.data;
    while(y < fraise.height) {
        while(x < fraise.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Raisin
void drawImage_raisin(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)raisin.data;
    while(y < raisin.height) {
        while(x < raisin.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Kiwi
void drawImage_kiwi(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)kiwi.data;
    while(y < kiwi.height) {
        while(x < kiwi.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Haricot
void drawImage_haricot(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)haricot.data;
    while(y < haricot.height) {
        while(x < haricot.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Fonction principale
int main()
{
    char ch;
    pc.baud(9600);
    bt.baud(38400);

    pc.printf("Test1\n\r");

    unsigned int boutton_commande = 0;
    unsigned int boutton_retour = 0;
    unsigned int boutton_scanner = 0;
    unsigned int boutton_panier = 0;
    unsigned int boutton_valider = 0;
    unsigned int boutton_acceuil = 0;
    unsigned int nb_pommes = 0;
    unsigned int nb_poires = 0;
    unsigned int nb_oranges = 0;
    unsigned int nb_bananes = 0;
    unsigned int nb_tomates = 0;
    unsigned int nb_fraises = 0;
    unsigned int nb_raisins = 0;
    unsigned int nb_kiwis = 0;
    unsigned int nb_haricots = 0;
    float prix_total = 0;
    char buffer [50] ;

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    while(1) {
        //*** Ecran d'acceuil ***
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
        BSP_LCD_SetBackColor(LCD_COLOR_ORANGE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        HAL_Delay(1000);

        BSP_LCD_DisplayStringAt(0, 70, (uint8_t *)"BIENVENUE SUR CEL", CENTER_MODE);
        HAL_Delay(1000);

        //Bouton faire une commande
        Button commande(lcd_, ts_, 88, 160, 300, 50,
                        LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Faire une commande", Font20);
        commande.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);

        while(boutton_commande == 0) {
            if(commande.Touched()) {
                boutton_commande = 1;
            }
        }
        boutton_commande = 0;


        //*** Ecran produits ***
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        HAL_Delay(1000);
            
        //Bouton retour
        Button retour(lcd_, ts_, 33, 5, 90, 30,
                      LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Retour", Font16);
        retour.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);
        
        //Bouton scanner
        Button scanner(lcd_, ts_, 198, 5, 90, 30,
                       LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Scanner", Font16);
        scanner.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);
                       
        //Bouton panier
        Button panier(lcd_, ts_, 360, 5, 90, 30,
                      LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Panier", Font16);
        panier.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);
        
        HAL_Delay(1000);
            
        //Images produits
        drawImage_pomme(10,45);
        drawImage_poire(10,130);
        drawImage_orange(10,200);
        drawImage_banane(175,45);
        drawImage_tomate(165,122);
        drawImage_fraise(165,200);
        drawImage_raisin (320,35);
        drawImage_kiwi(330,125);
        drawImage_haricot(330,205);
        HAL_Delay(1000);
    
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
        //Noms produits
        BSP_LCD_SetFont(&Font12);
        BSP_LCD_DisplayStringAt(350, 55, (uint8_t *)"Pommes", CENTER_MODE);
        BSP_LCD_DisplayStringAt(350, 140, (uint8_t *)"Poires", CENTER_MODE);
        BSP_LCD_DisplayStringAt(350, 210, (uint8_t *)"Oranges", CENTER_MODE);
        BSP_LCD_DisplayStringAt(30, 55, (uint8_t *)"Bananes", CENTER_MODE);
        BSP_LCD_DisplayStringAt(30, 140, (uint8_t *)"Tomates", CENTER_MODE);
        BSP_LCD_DisplayStringAt(30, 210, (uint8_t *)"Fraises", CENTER_MODE);
        BSP_LCD_DisplayStringAt(190, 55, (uint8_t *)"Raisins", CENTER_MODE);
        BSP_LCD_DisplayStringAt(190, 140, (uint8_t *)"Kiwis", CENTER_MODE);
        BSP_LCD_DisplayStringAt(190, 210, (uint8_t *)"Haricots", CENTER_MODE);
        HAL_Delay(1000);

        //Prix produits
        BSP_LCD_SetFont(&Font8);
        BSP_LCD_DisplayStringAt(350, 75, (uint8_t *)"2,20 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(350, 160, (uint8_t *)"3,50 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(350, 230, (uint8_t *)"2,00 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(30, 75, (uint8_t *)"3,00 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(30, 160, (uint8_t *)"1,00 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(30, 230, (uint8_t *)"4,00 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(190, 75, (uint8_t *)"4,20 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(190, 160, (uint8_t *)"2,99 Euros/kg", CENTER_MODE);
        BSP_LCD_DisplayStringAt(190, 230, (uint8_t *)"1,50 Euros/kg", CENTER_MODE);
        HAL_Delay(1000);

        //Boutons produits
        Button pommes(lcd_, ts_, 15, 93, 130, 20,
                      LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        pommes.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button poires(lcd_, ts_, 15, 175, 130, 20,
                      LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        poires.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button oranges(lcd_, ts_, 15, 248, 130, 20,
                       LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        oranges.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button bananes(lcd_, ts_, 175, 93, 130, 20,
                       LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        bananes.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button tomates(lcd_, ts_, 175, 175, 130, 20,
                       LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        tomates.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button fraises(lcd_, ts_, 175, 248, 130, 20,
                       LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        fraises.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button raisins(lcd_, ts_, 335, 93, 130, 20,
                       LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        raisins.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button kiwis(lcd_, ts_, 335, 175, 130, 20,
                     LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        kiwis.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);

        Button haricots(lcd_, ts_, 335, 248, 130, 20,
                        LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Ajouter au panier", Font12);
        haricots.Draw(LCD_COLOR_ORANGE, LCD_COLOR_BLACK);
        HAL_Delay(1000);
        
        while(boutton_retour == 0 && boutton_scanner == 0 && boutton_panier == 0) {
            if(retour.Touched()) {
                boutton_retour = 1;
                nb_pommes = 0;
                nb_poires = 0;
                nb_oranges = 0;
                nb_bananes = 0;
                nb_tomates = 0;
                nb_fraises = 0;
                nb_raisins = 0;
                nb_kiwis = 0;
                nb_haricots = 0;
                prix_total = 0;
            }
            
            //*** Ecran scanner ***
            else if(scanner.Touched()) {
                boutton_scanner = 1;
                
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                BSP_LCD_SetFont(&Font20);
                BSP_LCD_SetBackColor(LCD_COLOR_ORANGE);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                HAL_Delay(1000);

                BSP_LCD_DisplayStringAt(0, 40, (uint8_t *)"Scanner le code barre", CENTER_MODE);
                BSP_LCD_DisplayStringAt(0, 60, (uint8_t *)"du produit", CENTER_MODE);
                HAL_Delay(1000);

                //Bouton retour vers la page acceuil
                Button acceuil(lcd_, ts_, 68, 215, 350, 40,
                                            LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Retour vers la page d'acceuil", Font16);
                acceuil.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);

                while(boutton_acceuil == 0) {
                    if(acceuil.Touched()) {
                        boutton_acceuil = 1;
                    }
                    //Lecture code-barres
                    else if(bt.readable()) {
                        ch=bt.getc();
                        pc.printf("%c\n\r",ch);                    
                        switch(ch)
                        {
                            case '1':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_pomme(165,135);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Pommes", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"2,22 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;    
                            case '2':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_poire(165,140);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Poires", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"3,50 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;
                            case '3':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_orange(165,135);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Oranges", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"2,00 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;
                            case '4':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_banane(175,140);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Bananes", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"3,00 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;   
                            case '5':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_tomate(165,135);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Tomates", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"1,00 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;   
                            case '6':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_fraise(165,135);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Fraises", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"4,00 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;   
                            case '7':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_raisin(150,128);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Raisins", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"4,20 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;   
                            case '8':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_kiwi(165,135);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Kiwis", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"2,99 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;   
                            case '9':
                                BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                                BSP_LCD_FillRect(135, 130, 200, 80);
                                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);   
                                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                                BSP_LCD_SetFont(&Font16);
                                BSP_LCD_DisplayStringAt(0, 110, (uint8_t *)"Le produit est :", CENTER_MODE);
                                drawImage_haricot(165,140);
                                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                                BSP_LCD_SetFont(&Font12);
                                BSP_LCD_DisplayStringAt(30, 145, (uint8_t *)"Haricots", CENTER_MODE);
                                BSP_LCD_SetFont(&Font8);
                                BSP_LCD_DisplayStringAt(30, 165, (uint8_t *)"1,50 Euros/kg", CENTER_MODE);
                                HAL_Delay(1000);
                                break;    
                        }
                    }
                }
                boutton_acceuil = 0;
            }
            
            else if(panier.Touched()) {
                boutton_panier = 1;
    
                //*** Ecran panier ***
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                HAL_Delay(1000);
    
                //Images produits
                drawImage_pomme (10,15) ;
                drawImage_poire (10,100) ;
                drawImage_orange (10,170) ;
                drawImage_banane (165,5) ;
                drawImage_tomate (165,92) ;
                drawImage_fraise (165,170) ;
                drawImage_raisin (320,5) ;
                drawImage_kiwi (330,95) ;
                drawImage_haricot (330,175) ;
                HAL_Delay(1000);
    
                BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
                //Noms produits
                BSP_LCD_SetFont(&Font12);
                BSP_LCD_DisplayStringAt(350, 25, (uint8_t *)"Pommes", CENTER_MODE);
                BSP_LCD_DisplayStringAt(350, 110, (uint8_t *)"Poires", CENTER_MODE);
                BSP_LCD_DisplayStringAt(350, 180, (uint8_t *)"Oranges", CENTER_MODE);
                BSP_LCD_DisplayStringAt(30, 25, (uint8_t *)"Bananes", CENTER_MODE);
                BSP_LCD_DisplayStringAt(30, 110, (uint8_t *)"Tomates", CENTER_MODE);
                BSP_LCD_DisplayStringAt(30, 180, (uint8_t *)"Fraises", CENTER_MODE);
                BSP_LCD_DisplayStringAt(190, 25, (uint8_t *)"Raisins", CENTER_MODE);
                BSP_LCD_DisplayStringAt(190, 110, (uint8_t *)"Kiwis", CENTER_MODE);
                BSP_LCD_DisplayStringAt(190, 180, (uint8_t *)"Haricots", CENTER_MODE);
                HAL_Delay(1000);
    
                //Prix produits
                BSP_LCD_SetFont(&Font8);
                BSP_LCD_DisplayStringAt(350, 45, (uint8_t *)"2,20 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(350, 130, (uint8_t *)"3,50 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(350, 200, (uint8_t *)"2,00 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(30, 45, (uint8_t *)"3,00 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(30, 130, (uint8_t *)"1,00 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(30, 200, (uint8_t *)"4,00 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(190, 45, (uint8_t *)"4,20 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(190, 130, (uint8_t *)"2,99 Euros/kg", CENTER_MODE);
                BSP_LCD_DisplayStringAt(190, 200, (uint8_t *)"1,50 Euros/kg", CENTER_MODE);
                HAL_Delay(1000);
    
                //Nombres produits dans panier
                BSP_LCD_SetFont(&Font12);
                BSP_LCD_SetBackColor(LCD_COLOR_ORANGE);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                sprintf(buffer, "Nombre : %d", nb_pommes);
                BSP_LCD_DisplayStringAt(325, 60, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_poires);
                BSP_LCD_DisplayStringAt(325, 145, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_oranges);
                BSP_LCD_DisplayStringAt(325, 215, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_bananes);
                BSP_LCD_DisplayStringAt(5, 60, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_tomates);
                BSP_LCD_DisplayStringAt(5, 145, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_fraises);
                BSP_LCD_DisplayStringAt(5, 215, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_raisins);
                BSP_LCD_DisplayStringAt(165, 60, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_kiwis);
                BSP_LCD_DisplayStringAt(165, 145, (uint8_t *)buffer, CENTER_MODE);
                sprintf(buffer, "Nombre : %d", nb_haricots);
                BSP_LCD_DisplayStringAt(165, 215, (uint8_t *)buffer, CENTER_MODE);
                HAL_Delay(1000);
    
                //Bouton valider la commande
                Button valider(lcd_, ts_, 88, 235, 300, 30,
                               LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Valider la commande", Font16);
                valider.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);
    
                while(boutton_valider == 0) {
                    if(valider.Touched()) {
                        boutton_valider = 1;
                    }
                }
                boutton_valider = 0;
    
    
                //*** Ecran prix total ***
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
                BSP_LCD_SetBackColor(LCD_COLOR_ORANGE);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                HAL_Delay(1000);
    
                BSP_LCD_DisplayStringAt(0, 70, (uint8_t *)"Prix total", CENTER_MODE);
                HAL_Delay(1000);
    
                BSP_LCD_SetFont(&Font20);
                BSP_LCD_SetBackColor(LCD_COLOR_RED);
                sprintf(buffer, "%0.2f Euros", prix_total);
                BSP_LCD_DisplayStringAt(0, 120, (uint8_t *)buffer, CENTER_MODE);
                HAL_Delay(1000);
    
                //Bouton retour vers la page d'acceuil
                Button acceuil(lcd_, ts_, 68, 215, 350, 40,
                               LCD_COLOR_BLUE, LCD_COLOR_BLACK, "Retour vers la page d'acceuil", Font16);
                acceuil.Draw(LCD_COLOR_GRAY, LCD_COLOR_BLACK);
    
                while(boutton_acceuil == 0) {
                    if(acceuil.Touched()) {
                        boutton_acceuil = 1;
                        nb_pommes = 0;
                        nb_poires = 0;
                        nb_oranges = 0;
                        nb_bananes = 0;
                        nb_tomates = 0;
                        nb_fraises = 0;
                        nb_raisins = 0;
                        nb_kiwis = 0;
                        nb_haricots = 0;
                        prix_total = 0;
                    }
                }
                boutton_acceuil = 0;
            }
            
            //Ajouts au panier
            else if(pommes.Touched()) {
                nb_pommes = nb_pommes + 1;
                prix_total = prix_total + 2.20;
                HAL_Delay(300);
            }
    
            else if(poires.Touched()) {
                nb_poires = nb_poires + 1;
                prix_total = prix_total + 3.50;
                HAL_Delay(300);
            }
    
            else if(oranges.Touched()) {
                nb_oranges = nb_oranges + 1;
                prix_total = prix_total + 2.00;
                HAL_Delay(300);
            }
    
            else if(bananes.Touched()) {
                nb_bananes = nb_bananes + 1;
                prix_total = prix_total + 3.00;
                HAL_Delay(300);
            }
    
            else if(tomates.Touched()) {
                nb_tomates = nb_tomates + 1;
                prix_total = prix_total + 1.00;
                HAL_Delay(300);
            }
    
            else if(fraises.Touched()) {
                nb_fraises = nb_fraises + 1;
                prix_total = prix_total + 4.00;
                HAL_Delay(300);
            }
    
            else if(raisins.Touched()) {
                nb_raisins = nb_raisins + 1;
                prix_total = prix_total + 4.20;
                HAL_Delay(300);
            }
    
            else if(kiwis.Touched()) {
                nb_kiwis = nb_kiwis + 1;
                prix_total = prix_total + 2.99;
                HAL_Delay(300);
            }
    
            else if(haricots.Touched()) {
                nb_haricots = nb_haricots + 1;
                prix_total = prix_total + 1.50;
                HAL_Delay(300);
            }
        }
        boutton_retour = 0;
        boutton_scanner = 0;
        boutton_panier = 0;
     }   
}