#include "mbed.h"
#include "rtos.h"
#include <math.h>
#include "MadgwickAHRS.h"
#include "Mag_track.h"
#include "Scattered_interpolator.h"

//----------------------------------------------------------------------------------------------------
// Global ariable declaration
DigitalOut D_1(PA_7);
DigitalOut D_2(PA_6);
Thread thread;
Ticker read_ticker;

/////// Bounce button interrupt
InterruptIn button1(USER_BUTTON);
volatile bool button1_pressed = false; // Used in the main loop
volatile bool button1_enabled = true; // Used for debouncing
Timeout button1_timeout; // Used for debouncing

/////// Flags
bool flag = false;
bool flag_data_ready = false;
bool go_flag = false; // 10 sec flag for Qinit set up

/////// External signal buffers  
int16_t Mag_read_buff[24];// 3*8 signed int_16 buffer read from sensor
int16_t Acc_read[3]={0,0,0};
int16_t Gyr_read[3]={0,0,0};
float q_init[4]={1,0,0,0};
float q_init_n[4]={1,0,0,0};//{-0.8489, 0.0046, -0.001, 0.5286};//{0,0,0,0}; //;

/////// Counters 
int16_t count_1=1;
int16_t count_2=1;



//---------------------------------------------------------------------------------------------------
// Function declarations

// Enables button when bouncing is over
void button1_enabled_cb(void)
{
     button1_enabled = true;
}

// ISR handling button pressed event
void button1_onpressed_cb(void)
{
     if (button1_enabled) { // Disabled while the button is bouncing
         button1_enabled = false;
         button1_pressed = true; // To be read by the main loop
         button1_timeout.attach(callback(button1_enabled_cb), 0.3); // Debounce time 300 ms
     }
}

/////// Toggle flag 
void toggle_flag() {
       flag = !flag;
       //myled = !myled;
}


//////////////////////////////////////////////////////////////
//  Sensors reading thread
//////////////////////////////////////////////////////////////
void read_thread(){
     PC.printf("Hello World 30/11/18 DAFG!\n");     
     int16_t i, j;        
     // Raw and Filtered signals buffers
     memset( Mag_read_buff, 0, sizeof( Mag_read_buff ) );    
     int16_t Mag_filt[24];   // 24 signed int_16 output values from filter
     int16_t Mag_filt_lp[24];// 24 signed int_16 output values from filter
     int16_t M_LP[3];        // 3 signed int_16 output values from filter
     // Quaternion update buffers
     float a[3]={0,0,0};
     float g[3]={0,0,0};
     float m[3]={0,0,0};     
     int32_t q[4]={0, 0, 0, 0};
     int32_t Q_out[4]={0, 0, 0, 0};
     float Q[4]={0,0,0,0};         
     //Buffers for magnetic signal rotation     
     float v_I[3]={0,0,0};
     float v_rotX[3]={0,0,0};
     int16_t v_rotX_int[24];
     memset( v_rotX_int, 0, sizeof( v_rotX_int ) );
     float Mag_filt_f[3];    
     // Buffers for envelope extraction
     int16_t maximum[6]={0,0,0,0,0,0};
     int16_t peak_index[6]={0,0,0,0,0,0};
     int16_t Env[3]={0,0,0};
     double R[3]={0,0,0};
     double phase[3]={0,0,0};
     int16_t Sign[2]={1,1};     
     // ID word buffer
     char data_out[4];
     data_out[0] = 0xDA;
     data_out[1] = 0x51;  //DA51 = 55889
     data_out[2] = 0xDA;
     data_out[3] = 0xF6;  // DAF6 = 56054
     
     
     
          
     while (1) {
         Thread::signal_wait(0x1);
         D_2=1;         
         flag_data_ready = false;
     ///////////////////////////////////////////////////////////
     ////  RUOTARE IL CAMPO
         Q[0]=q0; Q[1]=-q1; Q[2]=-q2; Q[3]=-q3;
         for(i=0;i<8;i++){
             Mag_filt_f[0]= (float)Mag_read_buff[i]; Mag_filt_f[1]= (float)Mag_read_buff[8+i]; Mag_filt_f[2]= (float)Mag_read_buff[16+i];
             Qrotate(Mag_filt_f,Q,v_I);
             Qrotate(v_I,q_init,v_rotX);
             v_rotX_int[i]=(int16_t)v_rotX[0]; v_rotX_int[8+i]=(int16_t)v_rotX[1]; v_rotX_int[16+i]=(int16_t)v_rotX[2];
         }
         
     ///////////////////////////////////////////////////////////
     //Filter block
         for(i=0;i<3;i++){
              for(j=0;j<8;j++){
                 //Band-Pass
                 firFixed( coeffs_bp, &v_rotX_int[i*8 + j], &Mag_filt[i*8 + j], 1, FILTER_LEN_BP, i, insamp);
                 //Low-Pass
                 firFixed( coeffs_lp, &Mag_read_buff[i*8 + j], &Mag_filt_lp[i*8 + j], 1, FILTER_LEN_LP, i,lp_insamp);
                 }
                 M_LP[i]=Mag_filt_lp[i*8 + 4];             
         }                   
             
     ///////////////////////////////////////////////////////////
     /// ENVELOPE EXTRACTION        
                 
         Env_extraction(Env, Mag_filt, maximum, peak_index, R, phase, Sign); 
                              
     ///////////////////////////////////////////////////////////
     /// Quaternion computing
         QUpdate(q, m, a, g, M_LP, Acc_read, Gyr_read, q_init_n, Q_out); 
                
     ///////////////////////////////////////////////////////////
     ///Send serial data: 20954 [1]| Envelope[3] | -2342 [1] | Quat [8] 
         
         if(go_flag){
              
              for(i=0; i<2; i++){   //// PAROLA  20954
                 PC.printf("%c",data_out[i]);
              }     
              for(i=0; i<3; i++){     // ENVELOPE
                 PC.printf("%c",(char)(Env[i] & 0xff));
                 PC.printf("%c",(char)(Env[i]>>8 & 0xff));
              }
              for(i=2; i<4; i++){   //// PAROLA -2342
                 PC.printf("%c",data_out[i]);
              }
              for(i=0;i<4;i++){
                 PC.printf("%c",(char)(Q_out[i] & 0xff));
                 PC.printf("%c",(char)(Q_out[i]>>8 & 0xff));
                 PC.printf("%c",(char)(Q_out[i]>>16 & 0xff));
                 PC.printf("%c",(char)(Q_out[i]>>24 & 0xff));
              }
            
         }
         D_2=0;
                                                              
     }
     
}


//////////////////////////////////////////////////////////////
//  Main Code
//////////////////////////////////////////////////////////////
int main(){
    PC.baud(921600); //115200  921600
    /////// Internal signal buffers
    int16_t Mag_read_in_buff[24];
    memset( Mag_read_in_buff, 0, sizeof( Mag_read_in_buff ) );
    int16_t Mag_in_read[3]={0,0,0};
    int16_t Acc_in_read[3]={0,0,0};
    int16_t Gyr_in_read[3]={0,0,0};
    int i;
    button1.fall(callback(button1_onpressed_cb)); // Attach ISR to handle button press event      
    // Init FIR filters
    firFixedInit();
    PC.printf("Press button start!\n");
    D_1=0;
    D_2=0;
    while (!button1_pressed){
             myled = !myled;
             wait(0.1);
         } 
    //Configure sensors
    sensor_setup();
    //Start sensor reading thread
    thread.start(read_thread);    
    //Timer begins, Freq = 800
    read_ticker.attach_us(&toggle_flag, 1250);
    while(1){
        if(flag){
             D_1=1;
        ///////////////////////////////////////////////////////////
        // Read Mag register and Calibration Correction
             Read_Mag(Mag_in_read);                         
        ///////////////////////////////////////////////////////////
        // Read acc + gyr register
             if(count_1 == 1){
                 Read_Acc(Acc_in_read);                 
                 }
             if(count_1 == 5){
                 Read_Gyr(Gyr_in_read);               
                 }
                 
        ///////////////////////////////////////////////////////////
        // Read Mag internal buffer fill         
             for(i=0;i<3;i++){   
                 Mag_read_in_buff[8*i + count_1] = Mag_in_read[i];
                 }
                 
        ///////////////////////////////////////////////////////////
        // External buffers updates and Signal Processing flag act             
             if(count_1 == 8){
                 count_1 = 0;
                 for(i=0;i<24;i++){
                     Mag_read_buff[i]=Mag_read_in_buff[i];
                     }
                 for(i=0;i<3;i++){
                     Acc_read[i]=Acc_in_read[i];
                     Gyr_read[i]=Gyr_in_read[i];
                     }
                 thread.signal_set(0x1);
                 }
                 
        ///////////////////////////////////////////////////////////
        // Counter updates and flag management         
             count_1++;
             if (count_2==8001){
                 go_flag=true;
                 beta = 0.1;//{-0.8489, 0.0046, -0.001, 0.5286}
                 q_init[0]=q0; q_init[1]=q1; q_init[2]=q2; q_init[3]=q3;
                 q_init_n[0]=q0; q_init_n[1]=-q1; q_init_n[2]=-q2; q_init_n[3]=-q3;
             }
             if (count_2 <=8001){
                 count_2++;
             }

             flag=0;
             D_1=0;
        }
    }     
         
}