#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "SDFileSystem.h"
#include "MSCFileSystem.h"
#include "PS2Keyboard.h"
#include <stdio.h>
#include <string.h>
#include <stdbool.h>

DigitalOut myled(LED1);
MSCFileSystem fs("usb");
LocalFileSystem local("local");
SDFileSystem sd(p5, p6, p7, p8, "sd"); //p9: SD present; p8: CS

TextLCD lcd(p15, p16, p17, p18, p19, p20); // rs, e, d4-d7
PS2Keyboard ps2kb(p12, p11); //clk, dat 
Serial pc(USBTX, USBRX); // define transmitter and receiver
EthernetNetIf eth;
HTTPClient http;

int main() {
    
    //Initialization
    int j = 0;
    int k = 0;
    bool capsLock = false;
    
    PS2Keyboard::keyboard_event_t evt_kb;
    
    char ac[100] = "";
    
    printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr){
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("Setup OK\n");
    lcd.printf("Setup OK");
    wait(2);
    
    /*
    for (int i=0; i<101; i++){
        abc = pc.getc();
        if (abc == 0x08){
            ac[i-1] = 0x00;
            i = i-2;
            lcd.cls();
            lcd.printf(&ac[0]);  
        }    
        else if (abc == 0x0D){
            lcd.cls();
            lcd.printf("Enter, dosya indiriliyor!");
            i=150;
        }
        else if (abc == 0xFC){
            ac[i] = '~';
            lcd.locate(0,0);
            lcd.printf(&ac[0]); 
        } 
        else if (abc == 0xF6){
            ac[i] = '%';
            lcd.locate(0,0);
            lcd.printf(&ac[0]); 
        } 
        else{
            ac[i] = abc; 
            lcd.locate(0,0);
            lcd.printf(&ac[0]);  
        }
         
    }*/
    char *slash;
    char *point;

    while(1){
        lcd.cls();
        lcd.printf("Waiting for     Input");
        while (k<200) {
            if (ps2kb.processing(&evt_kb)) {
                lcd.cls();

                if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x0E){ ac[j]='/'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x16){ ac[j]='1'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1E){  ac[j]='2'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x26){  ac[j]='3'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x25){  ac[j]='4'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2E){  ac[j]='5'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x36){  ac[j]='6'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3D){  ac[j]='7'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3E){  ac[j]='8'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x46){  ac[j]='9'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x45){  ac[j]='0'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4E){  ac[j]='*'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x5D){  ac[j]=','; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x29){  ac[j]=' '; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x79){  ac[j]='+'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x49){  ac[j]=';'; lcd.printf(&ac[0]); j++;}
                else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x66){  ac[j-1] = 0x00; lcd.cls(); lcd.printf(&ac[0]); j--;}
                
                else if(capsLock == true){
                    if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x15){  ac[j]='Q'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1D){  ac[j]='W'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x24){  ac[j]='E'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2D){  ac[j]='R'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2C){  ac[j]='T'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x35){  ac[j]='Y'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3C){  ac[j]='U'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x43){  ac[j]='I'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x44){  ac[j]='O'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4D){  ac[j]='P'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x5B){  ac[j]='~'; lcd.printf(&ac[0]); j++;}
                    
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1C){  ac[j]='A'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1B){  ac[j]='S'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x23){  ac[j]='D'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2B){  ac[j]='F'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x34){  ac[j]='G'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x33){  ac[j]='H'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3B){  ac[j]='J'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x42){  ac[j]='K'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4B){  ac[j]='L'; lcd.printf(&ac[0]); j++;}
                    
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1A){  ac[j]='Z'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x22){  ac[j]='X'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x21){  ac[j]='C'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2A){  ac[j]='V'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x32){  ac[j]='B'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x31){  ac[j]='N'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3A){  ac[j]='M'; lcd.printf(&ac[0]); j++;}
                    
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x58){  myled = 0; capsLock = false; lcd.printf(&ac[0]);}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4A){  ac[j]=':'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x5A){  lcd.printf("Downloading..."); k=201;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x55){  ac[j]='_'; lcd.printf(&ac[0]); j++;}
                }
                else if(capsLock == false){
                    if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x15){  ac[j]='q'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1D){  ac[j]='w'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x24){  ac[j]='e'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2D){  ac[j]='r'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2C){  ac[j]='t'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x35){  ac[j]='y'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3C){  ac[j]='u'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x43){  ac[j]='i'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x44){  ac[j]='o'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4D){  ac[j]='p'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x5B){  ac[j]='~'; lcd.printf(&ac[0]); j++;}
                    
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1C){  ac[j]='a'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1B){  ac[j]='s'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x23){  ac[j]='d'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2B){  ac[j]='f'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x34){  ac[j]='g'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x33){  ac[j]='h'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3B){  ac[j]='j'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x42){  ac[j]='k'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4B){  ac[j]='l'; lcd.printf(&ac[0]); j++;}
                    
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x1A){  ac[j]='z'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x22){  ac[j]='x'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x21){  ac[j]='c'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x2A){  ac[j]='v'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x32){  ac[j]='b'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x31){  ac[j]='n'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x3A){  ac[j]='m'; lcd.printf(&ac[0]); j++;}
                    
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x58){  myled = 1; capsLock = true; lcd.printf(&ac[0]);}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x4A){  ac[j]='.'; lcd.printf(&ac[0]); j++;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x5A){  lcd.printf("Downloading..."); k=201;}
                    else if(evt_kb.scancode[0]==0xF0 && evt_kb.scancode[1]==0x55){  ac[j]='-'; lcd.printf(&ac[0]); j++;}
                }
                else{
                    //lcd.printf(&ac[0]);
                }
            }
        }
        
        //Dividing file extension and name
        slash = strrchr(ac,'/');
        int c = (int)(slash - ac);
        point = strrchr(ac,'.');
        int d = (int)(point - ac);
        
        //For Debugging
        pc.printf("%d  \n", c);
        pc.printf("%d  \n", d);
        
        //Setting a file name and file path
        int fileNameLength=strlen(ac)-c+4;
        char fileName[fileNameLength];
        fileName[0]='/';
        fileName[1]='u';
        fileName[2]='s';
        fileName[3]='b';
        fileName[4]='/';
        
        pc.printf("%d  \n", strlen(ac));
        for(int i = 0; i<strlen(ac)-c+1; i++){
            fileName[i+5] = ac[i+c+1];
            pc.printf(&ac[i+c+1]);
        }
        
        pc.printf(fileName);
        
        pc.printf(ac);

        HTTPFile f(fileName); //Creates a file name with its path by using FAT File System
        
        HTTPResult r = http.get(&ac[0], &f);
        
        if(r==HTTP_OK){
          printf("Result OK\n"); 
          lcd.cls();
          lcd.printf("File is downloaded!");
        }
        else{
          printf("Error %d\n", r);
          lcd.cls();
          lcd.printf("File is not downloaded!");
        }
        for(int m=0; m < 100; m++){
            ac[m]=0x00;
        }
        wait(5);
        k=0;
        j=0;
        
    }
}

