#include "mbed.h"
#include "EthernetInterface.h"

#define IP       "*****"
#define MASK   "*****"
#define GW      "****"
#define PORT   **

int main (void){
    EthernetInterface eth;
    eth.init(IP, MASK, GW); //Assign a device ip, mask and gateway
    // eth.init();
    eth.connect();
    
    TCPSocketServer server;
    server.bind(PORT);
    server.listen();

    while (true) {
        TCPSocketConnection client;
        server.accept(client);
        client.set_blocking(false, 1500); // Timeout after (1.5)s

        printf("Connection from: %s\n", client.get_address());
        char buffer[256];
        while (true) {
            int n = client.receive(buffer, sizeof(buffer));
            if(n>0) {
                char a = buffer[0];
                if(a == '1') {
              client.send_all(eth.getIPAddress(),16);
                } else if(a == '2') {
               client.send_all(eth.getGateway(),16);
                } else if(a == '3') {
               client.send_all(eth.getMACAddress(),17);
                } else if(a == '4') {
               client.send_all(eth.getNetworkMask(),16);
                }else if(a == 'c'){
               client.close();
               break;
                }
                    client.send_all("\n",2);
                    n=0;
                    a='0';
                    
                }

            }
        }
    
}
