﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HealthSensorPlatform.DeviceDescriptions;
using RPCSupport.DeviceSupport;

namespace Maxim.CustomControls
{
    class MAX30001Info : Device
    {

        public MAX30001Info()
        {
            deviceDetails = new DeviceDetails();
            deviceDetails.type = DeviceDetails.eType.eMAX30001;

            initalizeDescription();

        }

        void initalizeDescription()
        {
            Info = new RegisterInfo[] {
                new RegisterInfo("STATUS",	    0x01,	3, RegisterInfo.RegisterType.ReadOnly),
                new RegisterInfo("EN_INT",	    0x02,	3),
                new RegisterInfo("EN_INT2",	    0x03,	3),
                new RegisterInfo("MNGR_INT",	0x04,	3),
                new RegisterInfo("MNGR_DYN",	0x05,	3),
                new RegisterInfo("SW_RST",	    0x08,	3, RegisterInfo.RegisterType.WriteOnly),
                new RegisterInfo("SYNCH",	    0x09,	3, RegisterInfo.RegisterType.WriteOnly),
                new RegisterInfo("FIFO_RST",	0x0A,	3, RegisterInfo.RegisterType.WriteOnly),
                new RegisterInfo("INFO",	    0x0F,	3, RegisterInfo.RegisterType.ReadOnly),
                new RegisterInfo("CNFG_GEN",	0x10,	3),
                new RegisterInfo("CNFG_CAL",	0x12,	3),
                new RegisterInfo("CNFG_EMUX",	0x14,	3),
                new RegisterInfo("CNFG_ECG",	0x15,	3),
                new RegisterInfo("CNFG_BMUX",	0x17,	3),
                new RegisterInfo("CNFG_BIOZ",	0x18,	3),
                new RegisterInfo("CNFG_PACE",   0x1A,	3),
                new RegisterInfo("CNFG_RTOR1",	0x1D,	3),
                new RegisterInfo("CNFG_RTOR2",	0x1E,	3)
           };

             
//bit description for STATUS
Descriptions(0x01).Add("Bit [23]", "EINT", "ECG FIFO Interrupt: indicates ECG records meeting/exceeding the ECG FIFO Interrupt Threshold (EFIT) are available for read back.  Remains active until ECG FIFO is read back to the extent required to clear the EFIT condition.");
Descriptions(0x01).Add("Bit [22]", "EOVF", "ECG FIFO Overflow: indicates the ECG FIFO has overflowed and the data record has been corrupted.  ");
Descriptions(0x01).Add("Bit [21]", "FSTINT", "ECG Fast Recovery Mode: Issued when the ECG Fast Recovery Mode is engaged (either manually or automatically).");
Descriptions(0x01).Add("Bit [20]", "DCLOFFINT", "DC Lead Off Detection Interrupt:  indicates the part has determined it is in an ECG/BIOZ Leads Off condition (as selected in CNFG_GEN) for more than 90ms. Remains active as long as the Leads Off condition persists even after a STATUS register read, then held until cleared by STATUS register read (30th SCLK) if condition has ceased.  Note: Exact time depends on BIOZ modulation frequency (the clock used for counting) and can range from 90ms to 140ms.");
Descriptions(0x01).Add("Bit [19]", "BINT", "BIOZ FIFO Interrupt: indicates BIOZ records meeting/exceeding the BIOZ FIFO Interrupt Threshold (BFIT) are available for read back.  Remains active until BIOZ FIFO is read back to the extent required to clear the BFIT condition.");
Descriptions(0x01).Add("Bit [18]", "BOVF", "BIOZ FIFO Overflow: indicates the BIOZ FIFO has overflowed and the data record has been corrupted.  ");
Descriptions(0x01).Add("Bit [17]", "BOVER", "BIOZ Over Range: indicates the BIOZ output magnitude has exceeded the BIOZ High Threshold (BLOFF_HI_IT) for at least 100ms, recommended for use in 2 and 4 electrode BIOZ Lead Off detection.");
Descriptions(0x01).Add("Bit [16]", "BUNDR", "BIOZ Under Range: indicates the BIOZ output magnitude has been bounded by the BIOZ Low Threshold (BLOFF_LO_IT) for at least 1.7 seconds, recommended for use in 4 electrode BIOZ Lead Off detection.");
Descriptions(0x01).Add("Bit [15]", "BCGMON", "BIOZ Current Generator Monitor:  indicates the DRVP and/or DRVN current generator has been in a Lead Off condition for at least 128ms, recommended for use in 4 electrode BIOZ Lead Off detection.");
Descriptions(0x01).Add("Bit [14]", "PINT", "PACE FIFO Interrupt: indicates PACE records are available for read back (should be used in conjunction with EINT).  ");
Descriptions(0x01).Add("Bit [13]", "POVF", "PACE FIFO Overflow: indicates the PACE FIFO has overflowed and the data record has been corrupted.  ");
Descriptions(0x01).Add("Bit [12]", "PEDGE", "PACE Edge Detection Interrupt: real time PACE edge indicator showing when the MAX30001 has determined a PACE edge occurred (note this is different than the PINT interrupt, which indicates when the detected edges are logged into the PACE FIFO).  Clear behavior is defined by CLR_PEDGE[1:0], see MNGR_INT for details.");
Descriptions(0x01).Add("Bit [11]", "LONINT", "Ultra Low Power Lead On Detection Interrupt: indicates the part has determined it is in a Leads On condition (as selected in CNFG_GEN).  Remains active while the Leads On condition persists, then held until cleared by STATUS read back (32nd SCLK).");
Descriptions(0x01).Add("Bit [10]", "RRINT", "ECG R to R Detector R Event Interrupt: Issued when the R to R detector has identified a new R event.");
Descriptions(0x01).Add("Bit [9]", "SAMP", "Sample Synchronization Pulse:  issued on the ECG/BIOZ base-rate sampling instant, for use in assisting µC monitoring and synchronizing other peripheral operations and data, generally recommended for use as a dedicated interrupt.  ECG is the default, BIOZ is used only when ECG is not in use.  Frequency is selected by SAMP_IT[1:0], see MNGR_INT for details.  Clear behavior is defined by CLR_SAMP, see MNGR_INT for details.");
Descriptions(0x01).Add("Bit [8]", "PLLINT", "PLL Unlocked Interrupt:  indicates the PLL has not yet achieved or has lost its phase lock.  PLLINT will only be asserted when the PLL is powered up and active (ECG and/or BIOZ Channel enabled).  Remains asserted while the PLL unlocked condition persists, then held until cleared by STATUS read back (32nd SCLK).  Note:  Writes to CNFG_GEN which either enable the PLL or alter the FMSTR setting will result in an issuance of PLLINT while the PLL re-achieves lock – users should allow this behavior to settle out before considering the data valid.");
Descriptions(0x01).Add("Bit [5]", "BCGMP", "BIOZ Current Generator Monitor individual outputs:  indicates the DRVP or DRVN current generator has been in a Lead Off condition for at least 128ms.  These are not strictly interrupt terms, but are detailed status bits, covered by the BCGMON interrupt term.");
Descriptions(0x01).Add("Bit [4]", "BCGMN", "BIOZ Current Generator Monitor individual outputs:  indicates the DRVP or DRVN current generator has been in a Lead Off condition for at least 128ms.  These are not strictly interrupt terms, but are detailed status bits, covered by the BCGMON interrupt term.");
Descriptions(0x01).Add("Bit [3]", "LDOFF_PH", "DC Lead Off Detection Detailed Status:  indicates the part has determined (as selected by CNFG_GEN):  ");
Descriptions(0x01).Add("Bit [2]", "LDOFF_PL", "ECGP/BIP is above the high threshold (VTHH), ECGP/BIP is below the low threshold (VTHL),");
Descriptions(0x01).Add("Bit [1]", "LDOFF_NH", "ECGN/BIN is above the high threshold (VTHH), ECGN/BIN is below the low threshold (VTHL), respectively.");
Descriptions(0x01).Add("Bit [0]", "LDOFF_NL", "Remain active as long as the Lead Off Detection is active and the Leads Off condition persists, then held until cleared by STATUS read back (32nd SCLK). These are not strictly interrupt terms, but are detailed status bits, covered by the DCLOFFINT bit.");
 
//bit description for EN_INT
Descriptions(0x02).Add("Bit [23]", "EN_EINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [22]", "EN_EOVF", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [21]", "EN_FSTINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [20]", "EN_DCLOFFINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [19]", "EN_BINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [18]", "EN_BOVF", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [17]", "EN_BOVER", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [16]", "EN_BUNDR", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [15]", "EN_BCGMON", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [14]", "EN_PINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [13]", "EN_POVF", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [12]", "EN_PEDGE", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [11]", "EN_LONINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [10]", "EN_RRINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [9]", "EN_SAMP", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [8]", "EN_PLLINT", @"Interrupt enable for INTB pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x02).Add("Bit [1:0]", "INTB_TYPE[1:0]", "INTB Port Type (EN_INT Selections)");
 
//bit description for EN_INT2
Descriptions(0x03).Add("Bit [23]", "EN_EINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [22]", "EN_EOVF2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [21]", "EN_FSTINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [20]", "EN_DCLOFFINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [19]", "EN_BINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [18]", "EN_BOVF2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [17]", "EN_BOVER2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [16]", "EN_BUNDR2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [15]", "EN_BCGMON2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [14]", "EN_PINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [13]", "EN_POVF2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [12]", "EN_PEDGE2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [11]", "EN_LONINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [10]", "EN_RRINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [9]", "EN_SAMP2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [8]", "EN_PLLINT2", @"Interrupt enable for INT2B pin.  
0 = Individual Interrupt bit is not included in (or masked from) the Interrupt logical OR Term 
1 = Individual Interrupt bit is included in (or unmasked from) the Interrupt logical OR Term");
Descriptions(0x03).Add("Bit [1:0]", "INTB2_TYPE[1:0]", "INT2B Port Type (EN_INT Selections)");
 
//bit description for MNGR_INT
Descriptions(0x04).Add("Bit [23:19]", "EFIT[4:0]", "ECG FIFO Interrupt Threshold (issues EINT based on number of unread FIFO records)");
Descriptions(0x04).Add("Bit [18:16]", "BFIT[2:0]", "BIOZ FIFO Interrupt Threshold (issues BINT based on number of unread FIFO records)");
Descriptions(0x04).Add("Bit [6]", "CLR_FAST", "FAST MODE Interrupt Clear Behavior ");
Descriptions(0x04).Add("Bit [5:4]", "CLR_RRINT[1:0]", "RTOR R Detect Interrupt (RRINT) Clear Behavior ");
Descriptions(0x04).Add("Bit [3]", "CLR_PEDGE", "PACE Edge Detect Interrupt (PEDGE) Clear Behavior ");
Descriptions(0x04).Add("Bit [2]", "CLR_SAMP", "Sample Synchronization Pulse (SAMP) Clear Behavior ");
Descriptions(0x04).Add("Bit [1:0]", "SAMP_IT[1:0]", "Sample Synchronization Pulse (SAMP) Frequency ");
 
//bit description for MNGR_DYN
Descriptions(0x05).Add("Bit [23:22]", "FAST[1:0]", "ECG Channel Fast Recovery Mode Selection (aka ECG High Pass Filter Bypass)");
Descriptions(0x05).Add("Bit [21:16]", "FAST_TH[5:0]", "Automatic Fast Recovery Threshold  ");
Descriptions(0x05).Add("Bit [15:8]", "BLOFF_HI_IT[7:0]", "BIOZ AC Lead Off Over-Range Threshold ");
Descriptions(0x05).Add("Bit [7:0]", "BLOFF_LO_IT[7:0]", "BIOZ AC Lead Off Under-Range Threshold ");
 
//bit description for SW_RST
Descriptions(0x08).Add("Bit [23:0]", "RESET", "Data Required for Execution  = 00_00_00");
 
//bit description for SYNCH
Descriptions(0x09).Add("Bit [23:0]", "SYNCH", "Data Required for Execution  = 00_00_00");
 
//bit description for FIFO_RST
Descriptions(0x0A).Add("Bit [23:0]", "FIFO_RST", "Data Required for Execution  = 00_00_00");
 
//bit description for INFO
Descriptions(0x0F).Add("Bit [19:16]", "REV_ID[3:0]", "Revision ID");
//Descriptions(0x0F).Add("Bit [14]", "SAMPLE", "Sample - Experimental Functionality Enable\n0 - Production functionality only\n1 - Experimental functionality");
//Descriptions(0x0F).Add("Bit [13:12]", "PART_ID[1:0]", "Part ID\n00 - MAX30004\n01 - MAX30001\n10 - MAX30002\n11 - MAX30003");
//Descriptions(0x0F).Add("Bit [11:0]", "SERIAL[11:0]", "Serial Number");
 
//bit description for CNFG_GEN
Descriptions(0x10).Add("Bit [23:22]", "EN_ULP_LON[1:0]", "Ultra Low Power Lead On Detection Enable");
Descriptions(0x10).Add("Bit [21:20]", "FMSTR[1:0]", "Master Clock Frequency");
Descriptions(0x10).Add("Bit [19]", "EN_ECG", "ECG Channel Enable");
Descriptions(0x10).Add("Bit [18]", "EN_BIOZ", "BIOZ Channel Enable");
Descriptions(0x10).Add("Bit [17]", "EN_PACE", "PACE Channel Enable");
Descriptions(0x10).Add("Bit [15:14]", "EN_BLOFF[1:0]", "BIOZ Digital Lead Off Detection Enable ");
Descriptions(0x10).Add("Bit [13:12]", "EN_DCLOFF", "DC Lead Off Detection Enable");
Descriptions(0x10).Add("Bit [11]", "DCLOFF_IPOL", "DC Lead Off Current Polarity (if current sources are enabled/connected)");
Descriptions(0x10).Add("Bit [10:8]", "DCLOFF_IMAG[2:0]", "DC Lead Off Current Magnitude Selection");
Descriptions(0x10).Add("Bit [7:6]", "DCLOFF_VTH[1:0]", "DC Lead Off Voltage Threshold Selection ");
Descriptions(0x10).Add("Bit [5:4]", "EN_RBIAS[1:0]", "Enable and Select Resistive Lead Bias Mode ");
Descriptions(0x10).Add("Bit [3:2]", "RBIASV[1:0]", "Resistive Bias Mode Value Selection ");
Descriptions(0x10).Add("Bit [1]", "RBIASP", "Enables Resistive Bias on Positive Input");
Descriptions(0x10).Add("Bit [0]", "RBIASN", "Enables Resistive Bias on Negative Input");
 
//bit description for CNFG_CAL
Descriptions(0x12).Add("Bit [22]", "CAL_EN_VCAL", "Calibration Source (VCALP and VCALN) Enable ");
Descriptions(0x12).Add("Bit [21]", "CAL_VMODE", "Calibration Source Mode Selection ");
Descriptions(0x12).Add("Bit [20]", "CAL_VMAG", "Calibration Source Magnitude Selection (VMAG)");
Descriptions(0x12).Add("Bit [14:12]", "CAL_FCAL[2:0]", "Calibration Source Frequency Selection (FCAL)");
Descriptions(0x12).Add("Bit [11]", "CAL_FIFTY", "Calibration Source Duty Cycle Mode Selection");
Descriptions(0x12).Add("Bit [10:0]", "CAL_THIGH[10:0]", "Calibration Source Time High Selection  ");
 
//bit description for CNFG_EMUX
Descriptions(0x14).Add("Bit [23]", "EMUX_POL", "ECG Input Polarity Selection");
Descriptions(0x14).Add("Bit [21]", "EMUX_OPENP", "Open the ECGP Input Switch (most often used for testing and calibration studies)");
Descriptions(0x14).Add("Bit [20]", "EMUX_OPENN", "Open the ECGN Input Switch (most often used for testing and calibration studies)");
Descriptions(0x14).Add("Bit [19:18]", "EMUX_CALP_SEL[1:0]", "ECGP Calibration Selection");
Descriptions(0x14).Add("Bit [17:16]", "EMUX_CALN_SEL[1:0]", "ECGN Calibration Selection");
 
//bit description for CNFG_ECG
Descriptions(0x15).Add("Bit [23:22]", "ECG_RATE[1:0]", "ECG Data Rate (also dependent on FMSTR selection, see CNFG_GEN and table below):");
Descriptions(0x15).Add("Bit [17:16]", "ECG_GAIN[1:0]", "ECG Channel Gain Setting ");
Descriptions(0x15).Add("Bit [14]", "ECG_DHPF", "ECG Channel Digital High Pass Filter Cutoff Frequency");
Descriptions(0x15).Add("Bit [13:12]", "ECG_DLPF[1:0]", "ECG Channel Digital Low Pass Filter Cutoff Frequency");
 
//bit description for CNFG_BMUX
Descriptions(0x17).Add("Bit [21]", "BMUX_OPENP", "Open the BIP Input Switch (most often used for testing and calibration studies)");
Descriptions(0x17).Add("Bit [20]", "BMUX_OPENN", "Open the BIN Input Switch (most often used for testing and calibration studies)");
Descriptions(0x17).Add("Bit [19:18]", "BMUX_CALP_SEL[1:0]", "BIP Calibration Selection (VCAL application to BIP/N inputs intended for use in PACE testing only.)");
Descriptions(0x17).Add("Bit [17:16]", "BMUX_CALN_SEL[1:0]", "BIN Calibration Selection (VCAL application to BIP/N inputs intended for use in PACE testing only.)");
Descriptions(0x17).Add("Bit [13:12]", "BMUX_CG_MODE[1:0]", "BIOZ Current Generator Mode Selection");
Descriptions(0x17).Add("Bit [11]", "BMUX_EN_BIST", "BIOZ Modulated Resistance Built-In-Self-Test (RMOD BIST) Mode Enable");
Descriptions(0x17).Add("Bit [10:8]", "BMUX_RNOM[2:0]", "BIOZ RMOD BIST Nominal Resistance Selection");
Descriptions(0x17).Add("Bit [6:4]", "BMUX_RMOD[2:0]", "BIOZ RMOD BIST Modulated Resistance Selection (See RMOD BIST Settings Table for details.)");
Descriptions(0x17).Add("Bit [1:0]", "BMUX_FBIST[1:0]", "BIOZ RMOD BIST Frequency Selection");
 
//bit description for CNFG_BIOZ
Descriptions(0x18).Add("Bit [23]", "BIOZ_RATE", "BIOZ Data Rate (also dependent on FMSTR selection, see CNFG_GEN):");
Descriptions(0x18).Add("Bit [22:20]", "BIOZ_AHPF[2:0]", "BIOZ/PACE Channel Analog High Pass Filter Cutoff Frequency and Bypass");
Descriptions(0x18).Add("Bit [19]", "EXT_RBIAS", "External Resistor Bias Enable");
Descriptions(0x18).Add("Bit [17:16]", "BIOZ_GAIN[1:0]", "BIOZ Channel Gain Setting ");
Descriptions(0x18).Add("Bit [15:14]", "BIOZ_DHPF[1:0]", "BIOZ Channel Digital High Pass Filter Cutoff Frequency");
Descriptions(0x18).Add("Bit [13:12]", "BIOZ_DLPF[1:0]", "BIOZ Channel Digital Low Pass Filter Cutoff Frequency");
Descriptions(0x18).Add("Bit [11:8]", "BIOZ_FCGEN[3:0]", "BIOZ Current Generator Modulation Frequency");
Descriptions(0x18).Add("Bit [7]", "BIOZ_CGMON", "BIOZ Current Generator Monitor");
Descriptions(0x18).Add("Bit [6:4]", "BIOZ_CGMAG[2:0]", "BIOZ Current Generator Magnitude");
Descriptions(0x18).Add("Bit [3:0]", "BIOZ_PHOFF[3:0]", "BIOZ Current Generator Modulation Phase Offset ");
 
//bit description for CNFG_PACE
Descriptions(0x1A).Add("Bit [23]", "PACE_POL", "PACE Input Polarity Selection");
Descriptions(0x1A).Add("Bit [19]", "PACE_GN_DIFF_OFF", "PACE Differentiator (Derivative) Mode");
Descriptions(0x1A).Add("Bit [18:16]", "PACE_GAIN[2:0]", "PACE Channel Gain Selection");
Descriptions(0x1A).Add("Bit [14]", "PACE_AOUT_LBW", "PACE Analog Output Buffer Bandwidth Mode ");
Descriptions(0x1A).Add("Bit [13:12]", "PACE_AOUT[1:0]", "PACE Single Ended Analog Output Buffer Signal Monitoring Selection");
Descriptions(0x1A).Add("Bit [7:4]", "PACE_DACP[3:0]", "PACE Detector Positive Comparator Threshold");
Descriptions(0x1A).Add("Bit [3:0]", "PACE_DACN[3:0]", "PACE Detector Negative Comparator Threshold");
 
//bit description for CNFG_RTOR1
Descriptions(0x1D).Add("Bit [23:20]", "RTOR_WNDW[3:0]", "R to R Window Averaging (Window Width = RTOR_WNDW[3:0]*8ms)");
Descriptions(0x1D).Add("Bit [19:16]", "RTOR_GAIN[3:0]", "R to R Gain (where Gain = 2^RTOR_GAIN[3:0], plus an auto-scale option)");
Descriptions(0x1D).Add("Bit [15]", "EN_RTOR", "ECG RTOR Detection Enable  ");
Descriptions(0x1D).Add("Bit [13:12]", "RTOR_PAVG[1:0]", "R to R Peak Averaging Weight Factor");
Descriptions(0x1D).Add("Bit [11:8]", "RTOR_PTSF[3:0]", "R to R Peak Threshold Scaling Factor");
 
//bit description for CNFG_RTOR2
Descriptions(0x1E).Add("Bit [21:16]", "RTOR_HOFF[5:0]", "R to R Minimum Hold Off ");
Descriptions(0x1E).Add("Bit [13:12]", "RTOR_RAVG[1:0]", "R to R Interval Averaging Weight Factor");
Descriptions(0x1E).Add("Bit [10:8]", "RTOR_RHSF[2:0]", "R to R Interval Hold Off Scaling Factor");

        }
    }
}
