﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;

namespace RPCSupport.Devices
{
    /* Optical */
    public class MAX30101 : ClientDevice
    {
        public const string CLASSNAME = "MAX30101";
        int slaveAddress;
        public MAX30101(RPCClient client, int slaveAddress)
            : base(client)
        {
            this.slaveAddress = slaveAddress;
        }
        public byte ReadReg(byte addr)
        {
            string reply = Call(CLASSNAME, "ReadReg", addr.ToString("X2"));
            return client.pipeline.StringToByte(reply);
        }
        public void WriteReg(byte addr, byte data)
        {
            Call(CLASSNAME, "WriteReg", addr.ToString("X2"), data.ToString("X2"));
        }

        private void InitStreaming()
        {
            client.pipeline.Discard();
            client.streaming.Init(client.pipeline);
            client.streaming.Start();
            //Call(CLASSNAME, "StreamTest");
            //CallNoReply(CLASSNAME, "StreamTest");
        }

        public void StopStreaming()
        {
            StopStreaming(true);
        }

        public void StopStreaming(bool connected)
        {
            if (connected)
                client.pipeline.SendSingleByte(' ');

            client.streaming.Stop();

            if (connected)
            {
                client.pipeline.Discard();
                Thread.Sleep(500);
                client.pipeline.Discard();
            }
        }

        public void SpO2mode_init(byte fifo_waterlevel_mark, byte sample_avg, byte sample_rate, byte pulse_width,
                                                                        byte red_led_current, byte ir_led_current, byte accelRateParameter)
        {
            InitStreaming();
            CallNoReply(CLASSNAME, "SpO2mode_init", 
                fifo_waterlevel_mark.ToString("X2"), 
                sample_avg.ToString("X2"),
                sample_rate.ToString("X2"),
                pulse_width.ToString("X2"),
                red_led_current.ToString("X2"),
                ir_led_current.ToString("X2"),
                accelRateParameter.ToString("X2")
                );
        }

        public void HRmode_init(byte fifo_waterlevel_mark, byte sample_avg, byte sample_rate, byte pulse_width, 
                                                                        byte red_led_current,byte accelRateParameter)
        {
            InitStreaming();
            CallNoReply(CLASSNAME, "HRmode_init",
                fifo_waterlevel_mark.ToString("X2"),
                sample_avg.ToString("X2"),
                sample_rate.ToString("X2"),
                pulse_width.ToString("X2"),
                red_led_current.ToString("X2"),
                accelRateParameter.ToString("X2")
                );
        }

        public void Multimode_init(byte fifo_waterlevel_mark, byte sample_avg, byte sample_rate, byte pulse_width,
                                            byte red_led_current, byte ir_led_current, byte green_led_current,
                                            byte slot_1, byte slot_2, byte slot_3, byte slot_4, byte accelRateParameter)
        {
            InitStreaming();
            CallNoReply(CLASSNAME, "Multimode_init",
                fifo_waterlevel_mark.ToString("X2"),
                sample_avg.ToString("X2"),
                sample_rate.ToString("X2"),
                pulse_width.ToString("X2"),
                red_led_current.ToString("X2"),
                ir_led_current.ToString("X2"),
                green_led_current.ToString("X2"),
                slot_1.ToString("X2"),
                slot_2.ToString("X2"),
                slot_3.ToString("X2"),
                slot_4.ToString("X2"),
                accelRateParameter.ToString("X2")
                );
        }

        public void SpO2mode_stop()
        {
            SpO2mode_stop(true);
        }

        public void SpO2mode_stop(bool connected)
        {
            StopStreaming(connected);

            if (connected)
            {
                Call(CLASSNAME, "SpO2mode_stop");
                System.Threading.Thread.Sleep(250);
                client.pipeline.Discard();
            }
        }

        public void HRmode_stop()
        {
            HRmode_stop(true);
        }

        public void HRmode_stop(bool connected)
        {
            StopStreaming(connected);

            if (connected)
            {
                Call(CLASSNAME, "HRmode_stop");
                System.Threading.Thread.Sleep(250);
                client.pipeline.Discard();
            }
        }

        public void Multimode_stop()
        {
            Multimode_stop(true);
        }

        public void Multimode_stop(bool connected)
        {
            StopStreaming(connected);

            if (connected)
            {
                Call(CLASSNAME, "Multimode_stop");
                System.Threading.Thread.Sleep(250);
                client.pipeline.Discard();
            }
        }

    }
}


