﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using RPCSupport;
using RPCSupport.Streaming;

namespace RPCSupportTest
{
    public class StreamHelper
    {
        RPCClient rpcClient;
        IPlotView view;

        public StreamHelper(RPCClient rpcClient, IPlotView view)
        {
            this.view = view;
            this.rpcClient = rpcClient;
            this.rpcClient.streaming.PartialArrayIntAvailable += new EventHandler<PartialArrayIntAvailableEventArgs>(OnPartialArrayIntAvailable);
        }

        public void OnPartialArrayIntAvailable(object sender, PartialArrayIntAvailableEventArgs e)
        {
            if ((e.reportID & 0xF0) == PartialArrayIntAvailableEventArgs.PACKET_MAX30101)
                view.Display(e.array1);
        }

        public void Start(byte fifo_waterlevel_mark, byte sample_avg, byte sample_rate, byte pulse_width,
                                                                        byte red_led_current, byte accelRateParameter)
        {
            rpcClient.MAX30101.HRmode_init(fifo_waterlevel_mark, sample_avg, sample_rate, pulse_width, red_led_current, accelRateParameter);
        }

        public void Stop()
        {
            rpcClient.MAX30101.HRmode_stop();
        }

        bool started = false;
        public void OnStartStop(object sender, EventArgs e)
        {
            if (!started)
            {
                Start(0x0f, 0, 0, 3, 0x33, (byte)(0 + 4));
                started = true;
            }
            else
            {
                Stop();
            }

        }
    }

    public interface IPlotView
    {
        int Points { get; }
        void Display(int[] array);
        //void Display();
    }

    public class PlotView : IPlotView
    {
        int points;

        public int Points
        {
            get 
            {
                return points;
            }
        }

        public void Display(int[] array)
        {
            points += array.Length;
        }
    }

}
