﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HealthSensorPlatform
{
    public class TemperatureValue
    {
        double temperature;
        int temperatureHex;
        //bool units;
        bool dataFormat;


        public TemperatureValue(double temperature)
        {
            this.temperature = temperature;
            temperatureHex = temperatureToHex(temperature, false);
        }

        public TemperatureValue(double temperature, bool dataFormat)
        {
            this.temperature = temperature;
            temperatureHex = temperatureToHex(temperature, dataFormat);
            this.dataFormat = dataFormat;
        }

        public TemperatureValue(int hex)
        {
            temperatureHex = hex;
            temperature = hexToTemperature(hex, false);
        }

        public TemperatureValue(int hex, bool dataFormat)
        {
            temperatureHex = hex;
            temperature = hexToTemperature(hex, dataFormat);
        }

        public double TemperatureC
        {
            get
            {
                return temperature;
            }
        }

        public double TemperatureF
        {
            get
            {
                return temperature * 9 / 5 + 32;
            }
        }
        public int TemperatureHex
        {
            get
            {
                return temperatureHex;
            }
        }
        /*public bool UnitsCelsius
        {
            get
            {
                return units;
            }
        }*/
        public bool DataFormat
        {
            get
            {
                return dataFormat;
            }
            set
            {
                dataFormat = DataFormat;
            }
        }

        double hexToTemperature(int hex, bool dataFormat)
        {
            int normalCode;
            int rawCode = hex;
            double celsius;

            if (rawCode > 0x7fff)
                normalCode = rawCode - 0x10000;
            else
                normalCode = rawCode;

            if (dataFormat == false)
                celsius = normalCode / Math.Pow(2, 8);
            else
                celsius = normalCode / Math.Pow(2, 8) + 64;

            return celsius;
        }

        int temperatureToHex(double temperature, bool dataFormat)
        {
            int code = 0;
            double temp = 0;

            if (dataFormat)
            {
                temp = temperature - 64;
            }
            else
            {
                temp = temperature;
            }

                code = (short)(temp * Math.Pow(2, 8));

                if (code < 0)
                    code += 0x10000;

                return code;
        }
    }
}
