﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Maxim.MAX30101GUI;
using HealthSensorPlatform.View;
using HealthSensorPlatform.CustomControls;
using RPCSupport;
using RPCSupport.Streaming;

namespace HealthSensorPlatform.Presenter
{
    class OpticalAlgorithmPresenter
    {
        private MaximAlgorithmClass algorithm;
        private IOpticalAlgorithmView view;

        private bool streaming;
        private int count;

        private bool validRed = false;
        private bool validGreen = false;
        private bool validIR = false;

        public OpticalAlgorithmPresenter(RPCClient rpcClient, MaximAlgorithmClass algorithm, IOpticalAlgorithmView view)
        {
            this.algorithm = algorithm;
            this.view = view;

            //((OpticalView)view).StreamingStartStop += new OpticalView.StreamingStartStopEventHandler(OnStreamingStartStop);
            ((OpticalView)view).StreamingStartStop += new EventHandler<StreamingStartStopEventArgs>(OnStreamingStartStop);
            rpcClient.streaming.PartialArrayIntAvailable += new EventHandler<PartialArrayIntAvailableEventArgs>(OnPartialArrayIntAvaible);
            algorithm.OnHeartRateSpO2dataAvailable += OnHeartRateSpO2DataAvailable; // view.DisplayAlgorithmResult;
        }

        public void OnHeartRateSpO2DataAvailable(double heartRateBPM, bool heartRateBPMValid, double heartRateBPMSignalStrength,
                double spO2Percent, bool spO2PercentValid, double spO2PercentSignalStrength)
        {
            view.DisplayAlgorithmResult(heartRateBPM, heartRateBPMValid, heartRateBPMSignalStrength,
                spO2Percent, spO2PercentValid, spO2PercentSignalStrength);
        }

        public void OnStreamingStartStop(object sender, StreamingStartStopEventArgs e)
        {
            streaming = e.state;
            count = 0;
            if (streaming)
            {
                algorithm.Clear();
                view.DisplayAlgorithmReset();
                switch (((OpticalView)view).ModeConfiguration)
                {
                    case OpticalView.eStreamMode.eHR:
                        validRed = true;
                        validIR = false;
                        validGreen = false;
                        break;
                    case OpticalView.eStreamMode.eSPO2:
                        validRed = true;
                        validIR = true;
                        validGreen = false;
                        break;
                    case OpticalView.eStreamMode.eMulti:
                        validRed = true;
                        validIR = true;
                        validGreen = true;
                        break;
                }
            }
        }

        public void OnPartialArrayIntAvaible(object sender, PartialArrayIntAvailableEventArgs e)
        {
            int numSamples;

            if (streaming)
            {
                if ((e.reportID & 0xF0) == PartialArrayIntAvailableEventArgs.PACKET_MAX30101)
                {
                    numSamples = e.array1.Length;

                    for (int i = 0; i < numSamples; i++)
                    {
                        int red = 0, ir = 0, green = 0;

                        if (e.array1.Length != 0)
                        {
                            red = e.array1[i];
                        }
                        if (e.array2.Length != 0)
                        {
                            ir = e.array2[i];
                        }
                        if (e.array3.Length != 0)
                        {
                            green = e.array3[i];
                        }

                        algorithm.ConsumeRedIRGreenLEDdata(count, ir, red, green, validIR, validRed, validGreen);
                        count++;
                    }
                }
            }
        }
    }
}
