﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HealthSensorPlatform.DeviceDescriptions;
using RPCSupport.DeviceSupport;

namespace Maxim.CustomControls
{
    public class LIS2DHInfo : Device
    {

        public LIS2DHInfo()
        {
            deviceDetails = new DeviceDetails();
            deviceDetails.InitI2c(2,0x32);

            Info = new RegisterInfo[] {
                new RegisterInfo("STATUS_REG_AUX",0x07),
                new RegisterInfo("OUT_TEMP_L",0x0C),
                new RegisterInfo("OUT_TEMP_H",0x0D),
                new RegisterInfo("INT_COUNTER_REG",0x0E),
                new RegisterInfo("WHO_AM_I",0x0F),
                new RegisterInfo("TEMP_CFG_REG",0x1F),
                new RegisterInfo("CTRL_REG1",0x20),
                new RegisterInfo("CTRL_REG2",0x21),
                new RegisterInfo("CTRL_REG3",0x22),
                new RegisterInfo("CTRL_REG4",0x23),
                new RegisterInfo("CTRL_REG5",0x24),
                new RegisterInfo("CTRL_REG6",0x25),
                new RegisterInfo("REFERENCE",0x26),
                new RegisterInfo("STATUS_REG2",0x27),
                new RegisterInfo("OUT_X_L",0x28),
                new RegisterInfo("OUT_X_H",0x29),
                new RegisterInfo("OUT_Y_L",0x2A),
                new RegisterInfo("OUT_Y_H",0x2B),
                new RegisterInfo("OUT_Z_L",0x2C),
                new RegisterInfo("OUT_Z_H",0x2D),
                new RegisterInfo("FIFO_CTRL_REG",0x2E),
                new RegisterInfo("FIFO_SRC_REG",0x2F),
                new RegisterInfo("INT1_CFG",0x30),
                new RegisterInfo("INT1_SOURCE",0x31),
                new RegisterInfo("INT1_THS",0x32),
                new RegisterInfo("INT1_DURATION",0x33),
                new RegisterInfo("INT2_CFG",0x34),
                new RegisterInfo("INT2_SOURCE",0x35),
                new RegisterInfo("INT2_THS",0x36),
                new RegisterInfo("INT2_DURATION",0x37),
                new RegisterInfo("CLICK_CFG",0x38),
                new RegisterInfo("CLICK_SRC",0x39),
                new RegisterInfo("CLICK_THS",0x3A),
                new RegisterInfo("TIME_LIMIT",0x3B),
                new RegisterInfo("TIME_LATENCY",0x3C),
                new RegisterInfo("TIME_WINDOW",0x3D),
                new RegisterInfo("Act_THS",0x3E),
                new RegisterInfo("Act_DUR",0x3F)
           };

            // register 0x00
            Descriptions(0x07).Add("Bit 0", "PWR_RDY", "Power Ready Flag");
            Descriptions(0x07).Add("Bit 4", "PROX_INT", "Proximity Threshold Triggered");
            // register 0x01
            Descriptions(0x0C).Add("Bit 1", "DIE_TEMP_RDY", "Internal Temperature Ready Flag");
            // register 0x02
            Descriptions(0x0D).Add("Bit 4", "PROX_INT_EN", "Proximity Threshold Enable");
        }
    }
}
