/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//using Maxim.Global;

namespace MAX30205EVKit.View
{
    //public delegate void StartStopHandler(object sender, EventArgs e);

    /// <summary>
    /// View Interface which supports streaming data
    /// </summary>
    public interface IFileLogView
    {
        bool Enable { get; set; } // Some views can be disabled such as file

        /// <summary>
        /// Set start time for data
        /// </summary>
        DateTime StartTime { set; }

        /// <summary>
        /// Occurs when error from hardware
        /// </summary>
//        event EventHandler<ErrorEventArgs> Error;

        //event EventHandler<PartialArrayIntAvailableEventArgs> PartialArrayIntAvailable;

        bool SelectCSVFile(string fileName);

        bool SelectCSVFile(string fileName, DateTime time);

        /// <summary>
        /// Notify the start or stop of streaming
        /// </summary>
        void StreamStartStop(int channelCount);

        /// <summary>
        /// Write string to file
        /// </summary>
        /// <param name="str"></param>
        void WriteLine(string str);

        /// <summary>
        /// Write Temperature Data to CSV file
        /// </summary>
        void WriteTemp(double time, double tempr);
    }
}
