﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

//------------------------------------------------------------------------------------------
// OS24EVK-59 split into HeartRateApp EXE and MAX30101 DLL.
// Moved all MAX30101 DLL classes into namespace Maxim.MAX30101GUI
// Moved all HeartRateApp GUI classes into namespace Maxim.MAX30101
// OS24EVK-59 Create separate project that builds Maxim.MAX30101GUI DLL library

namespace Maxim.MAX30101GUI
{
    interface InterfaceRedIRGreenLEDdataConsumer
    {
        /// <summary>
        /// <para>Producer-Consumer data sink for
        /// raw Red/IR/Green LED data.
        /// Produced by MAX30101, consumed by algorithm.
        /// </para>
        /// </summary>
        /// <param name="sampleNumber"></param>
        /// <param name="rawIR"></param>
        /// <param name="rawRed"></param>
        /// <param name="rawGreen"></param>
        /// <param name="rawIRvalid"></param>
        /// <param name="rawRedvalid"></param>
        /// <param name="rawGreenvalid"></param>
        void ConsumeRedIRGreenLEDdata(
                int sampleNumber,
                int rawIR,
                int rawRed,
                int rawGreen,
                bool rawIRvalid,
                bool rawRedvalid,
                bool rawGreenvalid
            );

        // prepare for OS24EVK-37 by adding SensorTemperatureDegreesC(double) to InterfaceRedIRGreenLEDdataConsumer
        /// <summary>
        /// <para>Temperature measured at MAX30101, optionally used by algorithm to estimate actual Red LED wavelength.</para>
        /// </summary>
        /// <param name="temperatureDegreesC"></param>
        void SensorTemperatureDegreesC(double temperatureDegreesC);

    }
}
