﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RPCSupport.DeviceSupport
{
    public class RegisterInfo
    {
        public String name;
        public int address;
        public int[] data;
        public int numBytes = 1;
        public RegisterBitDescriptions description;
        public RegisterType type;
        public RegisterInfo(String name, int address, RegisterType type)
        {
            this.name = name;
            this.address = address;
            data = new int[numBytes];
            description = new RegisterBitDescriptions();
            this.type = type;
        }

        public RegisterInfo(String name, int address) : this (name, address, RegisterType.None)
        {
        }

        public RegisterInfo(String name, int address, int numBytes, RegisterType type)
        {
            this.name = name;
            this.address = address;
            this.numBytes = numBytes;
            data = new int[numBytes];
            description = new RegisterBitDescriptions();
            this.type = type;
        }

        public RegisterInfo(String name, int address, int numBytes) : this (name, address, numBytes, RegisterType.None)
        {

        }

        public string detailedName
        {
            get
            {
                string longName = name;

                if (type == RegisterType.ReadOnly)
                    longName += " (Read Only)";
                else if (type == RegisterType.WriteOnly)
                    longName += " (Write Only)";

                return longName;
            }
        }

        public int dataField
        {
            get
            {
                int val = 0;
                int temp;

                // For Temperature Sensor and standard I2C device
                for (int i = 0; i < numBytes; i++)
                {
                    temp = data[i] << ((numBytes - 1 - i) * 8);
                    //temp = reg.data[i] << 8 * i;
                    val |= temp;
                }

                return val;
            }
        }

        public enum RegisterType
        {
            ReadOnly,
            WriteOnly,
            None
        };
    }
}
