﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace Maxim.Utility
{
    public class FileCsvReader
    {
        StreamReader inputStream = null;
        OpenFileDialog fileDialog = new OpenFileDialog();

        string fileDirectory;

        public FileCsvReader()
        {
            fileDirectory = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);
        }

        public bool OpenCSVFile()
        {
            fileDialog.InitialDirectory = fileDirectory;
            fileDialog.Filter = "CSV files (*.csv)|*.csv|All files (*.*)|*.*";
            if (fileDialog.ShowDialog() == DialogResult.OK)
            {
                fileDirectory = Path.GetDirectoryName(fileDialog.FileName);
                inputStream = new StreamReader(fileDialog.FileName);
                return true;
            }
            else
                return false;
        }

        public string FileDirectory
        {
            get
            {
                return fileDirectory;
            }
            set
            {
                fileDirectory = value;
            }
        }

        public int Peek()
        {
            return inputStream.Peek();
        }

        public string ReadLine()
        {
            return inputStream.ReadLine();
        }

        public string[] ReadLineElements()
        {
            string str = ReadLine();

            string[] items = str.Split(',');

            return items;
        }

        public void Close()
        {
            inputStream.Close();
        }
    }
}
