﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using HealthSensorPlatform.View;
using Maxim.CustomControls;

namespace HealthSensorPlatform
{
    public partial class RegisterExportForm : Form, IRegisterExportView
    {
        public RegisterExportForm()
        {
            InitializeComponent();

            registerExport1.Complete += new EventHandler<CustomControls.RegisterExportEventArgs>(OnComplete);
        }

        public List<string> Devices
        {
            get
            {
                List<string> devicesList = new List<string>();

                foreach(string str in registerExport1.ItemsLeft)
                {
                    devicesList.Add(str);
                }

                return devicesList;
            }
            set
            {
                registerExport1.ItemsLeft.Clear();
                registerExport1.ItemsLeft.AddRange(value.ToArray());
            }
        }

        public List<string> SelectedDevices
        {
            get
            {
                List<string> devicesList = new List<string>();

                foreach (string str in registerExport1.ItemsRight)
                {
                    devicesList.Add(str);
                }

                return devicesList;
            }
            set
            {
                registerExport1.ItemsRight.Clear();
                registerExport1.ItemsRight.AddRange(value.ToArray());
            }
        }

        public event EventHandler<CompleteEventArgs> SelectionComplete;

        void OnComplete(object sender, CustomControls.RegisterExportEventArgs e)
        {
            if (e.Button == CustomControls.RegisterExportView.Button.Export)
            {
                if (SelectionComplete != null)
                    SelectionComplete(this, new CompleteEventArgs() { Complete = true });
            }
            else
            {
                if (SelectionComplete != null)
                    SelectionComplete(this, new CompleteEventArgs() { Complete = false});
            }

            Hide();
        }

        private void RegisterExportForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            // Override closing of the window with hiding
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                Hide();
            }
        }
    }
}
