﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

namespace MaximStyle
{
    public struct MaximColor
    {
        static Color teal = Color.FromArgb(0x00, 0xB2, 0xA9);
        static Color purple = Color.FromArgb(0x6E, 0x25, 0x85);
        static Color green = Color.FromArgb(0x99, 0xC6, 0x4C);
        static Color red = Color.FromArgb(0xFF, 0x00, 0x00);
        static Color yellow = Color.FromArgb(0xFF, 0xC2, 0x20);
        static Color lightBlue = Color.FromArgb(0x93, 0xc3, 0xde);
        static Color orange = Color.FromArgb(241, 92, 34);

        // Generic Names for Colors
        public static Color Teal { get { return teal; } }
        public static Color Purple { get { return purple; } }
        public static Color Green { get { return green; } }
        public static Color Red { get { return red; } }
        public static Color Yellow { get { return yellow; } }
        public static Color LightBlue { get { return lightBlue; } }
        public static Color Orange { get { return orange; } }

        // SET Look & Feel Names
        public static Color Background
        {
            get
            {
                return Color.White;
            }
        }
        public static Color AlternateBackground 
        {
            get 
            {
                return Color.FromArgb(0xdd, 0xdd, 0xdd);
            }
        }
        public static Color Outline 
        {
            get
            {
                return Color.FromArgb(0xce, 0xce, 0xce);
            }
        }
        public static Color InactiveSection 
        {
            get
            {
                return Color.FromArgb(0xad, 0xad, 0xad);
            }
        }
        public static Color Borders = Color.FromArgb(0x6c, 0x6f, 0x70);
        public static Color MainText = Color.Black;
        public Color Links
        {
            get
            {
                return teal;
            }
        }
        public static Color MouseoverLinkActiveElements
        {
            get
            {
                return purple;
            }
        }
        public static Color FollowedLink 
        {
            get
            {
                return Color.FromArgb(0x96, 0x96, 0x96);
            }
        }
        public static Color Warning
        {
            get
            {
                return yellow;
            }
        }
        public static Color GoOK
        {
            get
            {
                return green;
            }
        }
        public static Color Error
        {
            get
            {
                return red;
            }
        }

    }
}
