﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Maxim.CustomControls;
using HealthSensorPlatform.DeviceDescriptions;
using RPCSupport.DeviceSupport;

namespace Maxim.CustomControls
{
    public class MAX30101Info : Device
    {  

        public MAX30101Info() 
        {
            deviceDetails = new DeviceDetails();
            deviceDetails.InitI2c(2, 0xAE);

            Info = new RegisterInfo[] {
                            new RegisterInfo("Interrupt Status 1",0x00),
                            new RegisterInfo("Interrupt Status 2",0x01),
                            new RegisterInfo("Interrupt Enable 1",0x02),
                            new RegisterInfo("Interrupt Enable 2",0x03),
                            new RegisterInfo("FIFO Write Pointer",0x04),
                            new RegisterInfo("Over Flow Counter",0x05),
                            new RegisterInfo("FIFO Read Pointer",0x06),
                            new RegisterInfo("FIFO Data Register",0x07), 
                            new RegisterInfo("FIFO Configuration",0x08),
                            new RegisterInfo("Mode Configuration",0x09),
                            new RegisterInfo("SPO2 Configuration",0x0A),
                            new RegisterInfo("LED1 Pulse Amplitude (Red)",0x0C),
                            new RegisterInfo("LED2 Pulse Amplitude (IR)",0x0D),
                            new RegisterInfo("LED3 Pulse Amplitude (Green)",0x0E), 
                            new RegisterInfo("LED4 Pulse Amplitude (Green)",0x0F),
                            new RegisterInfo("Proximity Mode LED Pulse Amplitude",0x10), 
                            new RegisterInfo("Multi-LED Mode Control Register timeslot 1 and 2",0x11),
                            new RegisterInfo("Multi-LED Mode Control Register timeslot 3 and 4",0x12),
                            new RegisterInfo("Die Temperature integer",0x1F),
                            new RegisterInfo("Die Temperature fraction",0x20), 
                            new RegisterInfo("Die Temperature Config",0x21),
                            new RegisterInfo("Proximity Interrupt Threshold",0x30), 
                            new RegisterInfo("Revision ID",0xFE),
                            new RegisterInfo("Part ID",0xFF)
                        };

            // register 0x00
            Descriptions(0x00).Add("Bit 7", "A_FULL", "FIFO Almost Full Flag");
            Descriptions(0x00).Add("Bit 6", "PPG_RDY", "New FIFO Data Ready");
            Descriptions(0x00).Add("Bit 5", "ALC_OVF", "Ambient Light Cancellation Overflow");
            Descriptions(0x00).Add("Bit 4", "PROX_INT", "Proximity Threshold Triggered");
            Descriptions(0x00).Add("Bit 0", "PWR_RDY", "Power Ready Flag");
            // register 0x01
            Descriptions(0x01).Add("Bit 1", "DIE_TEMP_RDY", "Internal Temperature Ready Flag");
            // register 0x02
            Descriptions(0x02).Add("Bit 7", "A_FULL_EN", "FIFO Almost Full Flag Enable");
            Descriptions(0x02).Add("Bit 6", "PPG_RDY_EN", "New FIFO Data Ready Enable");
            Descriptions(0x02).Add("Bit 5", "ALC_OVF_EN", "Ambient Light Cancellation Overflow Enable");
            Descriptions(0x02).Add("Bit 4", "PROX_INT_EN", "Proximity Threshold Enable");
            // register 0x03
            Descriptions(0x03).Add("Bit 1", "DIE_TEMP_RDY_EN", "Internal Temperature Ready Flag Enable");
            // register 0x04
            Descriptions(0x04).Add("Bit [4:0]", "FIFO_WR_PTR[4:0]", "FIFO Write Pointer");
            // register 0x05
            Descriptions(0x05).Add("Bit [4:0]", "OVF_COUNTER[4:0]", "FIFO Overflow Counter");
            // register 0x06
            Descriptions(0x06).Add("Bit [4:0]", "FIFO_RD_PTR[4:0]", "FIFO Read Pointer");
            // register 0x07
            Descriptions(0x07).Add("Bit [7:0]", "FIFO_DATA[7:0]", "FIFO Data Register");
            // register 0x08
            Descriptions(0x08).Add("Bit [7:5]", "SMP_AVE[2:0]", "Sample Averaging");
            Descriptions(0x08).Add("Bit 4", "FIFO_ROLLOVER_EN", "FIFO Rolls on Full");
            Descriptions(0x08).Add("Bit [3:0]", "FIFO_A_FULL[3:0]", "FIFO Almost Full Value");
            // register 0x09
            Descriptions(0x09).Add("Bit 7", "SHDN", "Shutdown Control");
            Descriptions(0x09).Add("Bit 6", "RESET", "Reset Control");
            Descriptions(0x09).Add("Bit [2:0]", "MODE[2:0]", "Mode Control");
            // register 0x0a
            Descriptions(0x0a).Add("Bit [6:5]", "SPO2_ADC_RGE[1:0]", "SP02 ADC Range Control");
            Descriptions(0x0a).Add("Bit [4:2]", "SPO2_SR[2:0]", "SP02 Sample Rate Control");
            Descriptions(0x0a).Add("Bit [1:0]", "LED_PW[1:0]", "LED Pulse Width Control and ADC Resolution");
            // register 0x0c
            Descriptions(0x0c).Add("Bit [7:0]", "LED1_PA[7:0]", "LED1 Pulse Amplitude (RED)");
            Descriptions(0x0d).Add("Bit [7:0]", "LED2_PA[7:0]", "LED2 Pulse Amplitude (IR)");
            // register 0x0f
            Descriptions(0x0f).Add("Bit [7:0]", "LED4_PA[7:0]", "LED4 Pulse Amplitude (Green)");
            // register 0x10
            Descriptions(0x10).Add("Bit [7:0]", "PILOT_PA[7:0]", "Proximity Mode LED Pulse Amplitude");
            // register 0x11
            Descriptions(0x11).Add("Bit [6:4]", "SLOT2[2:0]", "Time slot 2");
            Descriptions(0x11).Add("Bit [2:0]", "SLOT1[2:0]", "Time slot 1");
            // register 0x12
            Descriptions(0x12).Add("Bit [6:4]", "SLOT4[2:0]", "Time slot 4");
            Descriptions(0x12).Add("Bit [2:0]", "SLOT3[2:0]", "Time slot 3");
            // register 0x1f
            Descriptions(0x1f).Add("Bit [7:0]", "TINT[7:0]", "Temperature Integer");
            // register 0x20
            Descriptions(0x20).Add("Bit [7:0]", "TFRAC[3:0]", "Temperature Fraction");
            // register 0x21
            Descriptions(0x21).Add("Bit 0", "TEMP_EN", "Temperature Enable");
            // register 0x30
            Descriptions(0x30).Add("Bit [7:0]", "PROX_INT_THRESH[7:0]", "Proximity Mode Interrupt Threshold");
            // register 0xfe
            Descriptions(0xfe).Add("Bit [7:0]", "REV_ID[7:0]", "Revision ID");
            // register 0xff
            Descriptions(0xff).Add("Bit [7:0]", "PART_ID[7:0]", "Part ID");
        }
    }
}