﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform
{
    public partial class HspForm
    {
        List<RegisterField> bioZChannelField = new List<RegisterField>();

        RegisterField bioZSampleRateField; // Needed for dynamic changing of options
        RegisterField bioZDlpfField;
        RegisterField bioZCgmagField;

        string[][] bioZSampleRateOptions = new string[][] 
            { 
                new string[] { "64 sps*", "32 sps" }, 
                new string[] { "62.5 sps*", "31.25 sps" }, 
                new string[] { "50 sps*", "25 sps" }, 
                new string[] { "49.95 sps*", "24.98 sps" } 
            };

        string[][] bioZCgmagOptions = { new string[] { "Off*", "8 μA", "16 μA", "32 μA", "48 μA", "64 μA", "80 μA", "96 μA" },
                                        new string[] { "Off*", "8 μA", "16 μA", "32 μA", "48 μA", "64 μA", "80 μA" },
                                        new string[] { "Off*", "8 μA", "16 μA", "32 μA" },
                                        new string[] { "Off*", "8 μA", "16 μA" },
                                        new string[] { "Off*", "8 μA" }
                                      };
			
		string[][][] bioZDlpfOptions;

        void initalizeBioZConfigFields()
        {
			bioZDlpfOptions = new string[4][][];
			
			for (int i = 0; i < 4; i++)
			{
				bioZDlpfOptions[i] = new string[2][];
			}
			
			// 32768 Hz
			bioZDlpfOptions[0][0] = new string[] {"Bypass", "4.096 Hz*", "8.192 Hz", "16.384 Hz"};
			bioZDlpfOptions[0][1] = new string[] {"Bypass", "4.096 Hz*", "8.192 Hz"}; //, "4.096 Hz"};
			// 32000 Hz
			bioZDlpfOptions[1][0] = new string[] {"Bypass", "4.0 Hz*", "8.0 Hz", "16.0 Hz"};
			bioZDlpfOptions[1][1] = new string[] {"Bypass", "4.0 Hz*", "8.0 Hz"}; //, "4.0 Hz"};
			// 32000 Hz
			bioZDlpfOptions[2][0] = new string[] {"Bypass", "4.0 Hz*", "8.0 Hz", "16.0 Hz"};
			bioZDlpfOptions[2][1] = new string[] {"Bypass", "4.0 Hz*", "8.0 Hz"}; //, "4.0 Hz"};
			// 31968 Hz
			bioZDlpfOptions[3][0] = new string[] {"Bypass", "3.996 Hz*", "7.992 Hz", "15.984 Hz"};
			bioZDlpfOptions[3][1] = new string[] {"Bypass", "3.996 Hz*", "7.992 Hz"}; //, "3.996 Hz"};
			
            string[] aHpfOptions = { "250 Hz", "500 Hz", "1000 Hz*", "2000 Hz", "4000 Hz", "8000 Hz", "Bypass" };
            string[] gainOptions = { "20 V/V*", "40 V/V", "80 V/V", "160 V/V" };
            string[] dlpfOptions = { "Bypass", "4 Hz*", "8 Hz", "16 Hz" };
            string[] dhpfOptions = { "Bypass (DC)*", "0.05 Hz", "0.50 Hz" };


            string[] fcgenOptions = { "4*FMSTR (~128 kHz)", "2*FMSTR (~80 kHz) - offset", "FMSTR (~40 kHz) - offset", "FMSTR/2 (~18 kHz) - offset",
                                    "FMSTR/4 (~8 kHz)", "FMSTR/8 (~4 kHz)", "FMSTR/16 (~2 kHz)", "FMSTR/32 (~1 kHz)",
                                    "FMSTR/64 (~500 Hz)*", "FMSTR/128 (~250 Hz)", "FMSTR/256 (~125 Hz)"};
            string[] cgmonOptions = { "Disabled*", "Enabled" };
            string[] extRbiasOptions = { "Internal*", "External" };
            string[] cgModeOptions = { "Unchopped w/ LPF*", "Chopped w/o LPF", "Chopped w/ LPF", "Chopped w/ Resistive CM" };

            string[] enBloffOptions = { "Disabled*", "Under Range", "Over Range", "Under and Over Range" };
            string[] hiITOptions = new string[256];
            string[] loITOptions = new string[256];

            for (int i = 0; i < hiITOptions.Length; i++)
            {
                hiITOptions[i] = "±2048 * " + i;
                loITOptions[i] = "±32 * " + i;
            }
            hiITOptions[255] += "*";
            loITOptions[255] += "*";

            string[] phoffOptions = new string[16];
            for (int i = 0; i < phoffOptions.Length/4; i++)
            {
                phoffOptions[4 * i] = (11.25 * 4 * i).ToString() + "°  (For all frequencies)";
                phoffOptions[4 * i + 1] = (11.25 * (4 * i + 1)).ToString() + "°  (For <= 40kHz)";
                phoffOptions[4 * i + 2] = (11.25 * (4 * i + 2)).ToString() + "°  (For <= 80kHz)";
                phoffOptions[4 * i + 3] = (11.25 * (4 * i + 3)).ToString() + "°  (For <= 40kHz)";
            }
            phoffOptions[0] += "*";

            string[] enDcloffOptions = { "Disabled*", "ECGP/N", "BIP/N" };

            bioZSampleRateField = new RegisterField { Name = "BIOZ_RATE", Register = 0x18, Index = 23, Width = 1, Descriptions = bioZSampleRateOptions[0], Label = lblBioZSampleRate, Control = cboBioZSampleRate, Device = max30001 };
            RegisterField aHpfField = new RegisterField { Name = "BIOZ_AHPF", Register = 0x18, Index = 20, Width = 3, Descriptions = aHpfOptions, Label = lblBioZAnalogHpf, Control = cboBioZAnalogHpf, Device = max30001 };
            RegisterField rbiasField = new RegisterField { Name = "\nEXT_RBIAS", Register = 0x18, Index = 19, Width = 1, Descriptions = extRbiasOptions, Label = lblBioZExternalResistorBiasEnable, Control = cboBioZExternalResistorBiasEnable, Device = max30001 };
            RegisterField gainField = new RegisterField { Name = "BIOZ_GAIN", Register = 0x18, Index = 16, Width = 2, Descriptions = gainOptions, Label = lblBioZChannelGain, Control = cboBioZChannelGain, Device = max30001 };
            RegisterField digitalHpfField = new RegisterField { Name = "BIOZ_DHPF", Register = 0x18, Index = 14, Width = 2, Descriptions = dhpfOptions, Label = lblBioZDigitalHpf, Control = cboBioZDigitalHpf, Device = max30001 };
            bioZDlpfField = new RegisterField { Name = "BIOZ_DLPF", Register = 0x18, Index = 12, Width = 2, Descriptions = dlpfOptions, Label = lblBioZDigitalLpf, Control = cboBioZDigitalLpf, Device = max30001 };
            RegisterField fcgenField = new RegisterField { Name = "BIOZ_FCGEN", Register = 0x18, Index = 8, Width = 4, Descriptions = fcgenOptions, Label = lblBioZCurrentGeneratorFrequency, Control = cboBioZCurrentGeneratorFrequency, Device = max30001 };
            RegisterField cgmonField = new RegisterField { Name = "BIOZ_CGMON", Register = 0x18, Index = 7, Width = 1, Descriptions = cgmonOptions, Label = lblBioZCurrentGeneratorMonitor, Control = cboBioZCurrentGeneratorMonitor, Device = max30001 };
            bioZCgmagField = new RegisterField { Name = "BIOZ_CGMAG", Register = 0x18, Index = 4, Width = 3, Descriptions = bioZCgmagOptions[0], Label = lblBioZCurrentGeneratorMagnitude, Control = cboBioZCurrentGeneratorMagnitude, Device = max30001 };
            RegisterField phoffField = new RegisterField { Name = "\nBIOZ_PHOFF", Register = 0x18, Index = 0, Width = 4, Descriptions = phoffOptions, Label = lblBioZModulationPhaseOffset, Control = cboBioZModulationPhaseOffset, Device = max30001 };
            bioZChannelField.Add(bioZSampleRateField);
            bioZChannelField.Add(aHpfField);
            bioZChannelField.Add(rbiasField);
            bioZChannelField.Add(gainField);
            bioZChannelField.Add(digitalHpfField);
            bioZChannelField.Add(bioZDlpfField);
            bioZChannelField.Add(fcgenField);
            bioZChannelField.Add(cgmonField);
            bioZChannelField.Add(bioZCgmagField);
            bioZChannelField.Add(phoffField);

            RegisterField cgmodeField = new RegisterField { Name = "BMUX_CG_MODE", Register = 0x17, Index = 12, Width = 2, Descriptions = cgModeOptions, Label = lblBioZCurrentGeneratorMode, Control = cboBioZCurrentGeneratorMode, Device = max30001 };
            RegisterField enDcloffField = new RegisterField { Name = "EN_BLOFF", Register = 0x10, Index = 14, Width = 2, Descriptions = enBloffOptions, Label = lblBioZDigitalLeadOffDetectionEnable, Control = cboBioZDigitalLeadOffDetectionEnable, Device = max30001 };
            RegisterField bloffHiItField = new RegisterField { Name = "BLOFF_HI_IT", Register = 0x05, Index = 8, Width = 8, Descriptions = hiITOptions, Label = lblBioZACLeadOffOverRangeThreshold, Control = cboBioZACLeadOffOverRangeThreshold, Device = max30001 };
            RegisterField bloffLoItField = new RegisterField { Name = "BLOFF_LO_IT", Register = 0x05, Index = 0, Width = 8, Descriptions = loITOptions, Label = lblBioZACLeadOffUnderRangeThreshold, Control = cboBioZACLeadOffUnderRangeThreshold, Device = max30001 };
            bioZChannelField.Add(cgmodeField);
            bioZChannelField.Add(enDcloffField);
            bioZChannelField.Add(bloffHiItField);
            bioZChannelField.Add(bloffLoItField);
        }

        void BioZChannelUpdateRegisters()
        {
            internalUpdate = true;
            ReadComboBoxesRegisters(bioZChannelField);
            internalUpdate = false;
        }

        private CustomControls.InitArgs.BIOZInitStart getBioZArgs()
        {
            CustomControls.InitArgs.BIOZInitStart biozArgs = new CustomControls.InitArgs.BIOZInitStart();

            biozArgs.Openp = cboBioZBmuxOpenp.SelectedIndex;
            biozArgs.Openn = cboBioZBmuxOpenn.SelectedIndex;
            biozArgs.Calp_sel = cboBioZBmuxCalpSel.SelectedIndex;
            biozArgs.Caln_sel = cboBioZBmuxCalnSel.SelectedIndex;
            biozArgs.CG_mode = cboBioZCurrentGeneratorMode.SelectedIndex;
            biozArgs.En_bioz = chkEnBioZ.Checked == true ? 1 : 0;
            biozArgs.B_fit = 7; // comboBox39.SelectedIndex;
            biozArgs.Rate = cboBioZSampleRate.SelectedIndex;
            biozArgs.Ahpf = cboBioZAnalogHpf.SelectedIndex;
            biozArgs.Ext_rbias = cboBioZExternalResistorBiasEnable.SelectedIndex;
            biozArgs.Gain = cboBioZChannelGain.SelectedIndex;
            biozArgs.Dhpf = cboBioZDigitalHpf.SelectedIndex;
            biozArgs.Dlpf = cboBioZDigitalLpf.SelectedIndex;
            biozArgs.Fcgen = cboBioZCurrentGeneratorFrequency.SelectedIndex;
            biozArgs.Cgmon = cboBioZCurrentGeneratorMonitor.SelectedIndex;
            biozArgs.Cgmag = cboBioZCurrentGeneratorMagnitude.SelectedIndex;
            biozArgs.Phoff = cboBioZModulationPhaseOffset.SelectedIndex;

            return biozArgs;
        }

        private void setBioZArgs(CustomControls.InitArgs.BIOZInitStart biozArgs)
        {
            cboBioZBmuxOpenp.SelectedIndex = biozArgs.Openp;
            cboBioZBmuxOpenn.SelectedIndex = biozArgs.Openn;
            cboBioZBmuxCalpSel.SelectedIndex = biozArgs.Calp_sel;
            cboBioZBmuxCalnSel.SelectedIndex = biozArgs.Caln_sel;
            cboBioZCurrentGeneratorMode.SelectedIndex = biozArgs.CG_mode;
            //biozArgs.En_bioz = chkEnBioZ.Checked == true ? 1 : 0;
            //biozArgs.B_fit = 7; // comboBox39.SelectedIndex;
            cboBioZSampleRate.SelectedIndex = biozArgs.Rate;
            cboBioZAnalogHpf.SelectedIndex = biozArgs.Ahpf;
            cboBioZExternalResistorBiasEnable.SelectedIndex = biozArgs.Ext_rbias;
            cboBioZChannelGain.SelectedIndex = biozArgs.Gain;
            cboBioZDigitalHpf.SelectedIndex = biozArgs.Dhpf;
            cboBioZDigitalLpf.SelectedIndex = biozArgs.Dlpf;
            cboBioZCurrentGeneratorFrequency.SelectedIndex = biozArgs.Fcgen;
            cboBioZCurrentGeneratorMonitor.SelectedIndex = biozArgs.Cgmon;
            cboBioZCurrentGeneratorMagnitude.SelectedIndex = biozArgs.Cgmag;
            cboBioZModulationPhaseOffset.SelectedIndex = biozArgs.Phoff;
        }

        public string BioZSettingString()
        {
            StringBuilder sb = new StringBuilder();
            
            foreach(RegisterField rf in bioZChannelField)
            {
                sb.Append(rf.Label.Text.Replace("\n", String.Empty));
                sb.Append(" = ");
                sb.Append(((MaximStyle.MaximComboBox)rf.Control).SelectedItem);
                sb.Append(", ");
            }

            return sb.ToString();
        }

        public string EcgSettingString()
        {
            StringBuilder sb = new StringBuilder();

            foreach (RegisterField rf in ecgChannelField)
            {
                sb.Append(rf.Label.Text.Replace("\n", String.Empty));
                sb.Append(" = ");
                sb.Append(((MaximStyle.MaximComboBox)rf.Control).SelectedItem);
                sb.Append(", ");
            }

            return sb.ToString();
        }


        private void cboBioZChannelGain_SelectedIndexChanged(object sender, EventArgs e)
        {
            MaximStyle.MaximComboBox cbox = (MaximStyle.MaximComboBox)sender;

            switch (cbox.SelectedIndex)
            {
                case 0:
                    ecgView1.GainBioZ = 20;
                    break;
                case 1:
                    ecgView1.GainBioZ = 40;
                    break;
                case 2:
                    ecgView1.GainBioZ = 80;
                    break;
                case 3:
                    ecgView1.GainBioZ = 160;
                    break;
            }
        }

        private void cboBioZCurrentGeneratorMagnitude_SelectedIndexChanged(object sender, EventArgs e)
        {
            MaximStyle.MaximComboBox cbox = (MaximStyle.MaximComboBox)sender;
            int[] currents = { 0, 8, 16, 32, 48, 64, 80, 96 };

            // Equation for Hex code to current magnitude
            ecgView1.CurrentBioZ = currents[cbox.SelectedIndex];
        }

        private void cboBioZSampleRate_SelectedIndexChanged(object sender, EventArgs e)
        {
            MaximStyle.MaximComboBox cbo = (MaximStyle.MaximComboBox)sender;
            double[][] sampleRates = new double[][]
            {
                new double[] {64, 32},
                new double[] {62.5, 31.25},
                new double[] {50, 25},
                new double[] {49.95, 24.98}
            };

            if (connected && !internalUpdate)
                writeComboBox(cbo);

            if (cboMasterClock.SelectedIndex > -1 && cbo.SelectedIndex > -1 && cboBioZDigitalLpf.SelectedIndex > -1) // All boxes are init
            {
                ecgView1.SampleRateBioZ = sampleRates[cboMasterClock.SelectedIndex][cbo.SelectedIndex];

                cboBioZDigitalLpf.Items.Clear();
                bioZDlpfField.Descriptions = bioZDlpfOptions[cboMasterClock.SelectedIndex][cboBioZSampleRate.SelectedIndex];
                bioZDlpfField.Control = cboBioZDigitalLpf; // Trigger update of descriptions

                cboBioZDigitalLpf.SelectedIndex = bioZDlpfField.ReadField();

            }
        }

        private void cboBioZCurrentGeneratorFrequency_SelectedIndexChanged(object sender, EventArgs e)
        {
            string[] currentOptions; 
            switch (cboBioZCurrentGeneratorFrequency.SelectedIndex)
            {
                case 0:
                case 1:
                case 2:
                case 3:
                    currentOptions = bioZCgmagOptions[0];
                    break;
                case 4:
                    currentOptions = bioZCgmagOptions[1];
                    break;
                case 5:
                    currentOptions = bioZCgmagOptions[2];
                    break;
                case 6:
                    currentOptions = bioZCgmagOptions[3];
                    break;
                default:
                    currentOptions = bioZCgmagOptions[4];
                    break;
            }

            if (cboBioZCurrentGeneratorMagnitude.SelectedIndex >= currentOptions.Length) // Force user selection to be valid
            {
                cboBioZCurrentGeneratorMagnitude.SelectedIndex = currentOptions.Length - 1;
            }
            bioZCgmagField.Descriptions = currentOptions;
            bioZCgmagField.Control = cboBioZCurrentGeneratorMagnitude; // Repopulate drop down options
        }

        private void cboBioZDigitalLeadOffDetectionEnable_SelectedIndexChanged(object sender, EventArgs e)
        {
            MaximStyle.MaximComboBox cbo = (MaximStyle.MaximComboBox)sender;

            if (cbo.SelectedIndex == 0)
                ecgView1.EnableBioZOverUnderRange = false;
            else
                ecgView1.EnableBioZOverUnderRange = true;
        }
       
    }
}
