﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using NUnit.Framework;
using HealthSensorPlatform.CustomControls;
using RPCSupport.Streaming;
using System.Windows.Forms;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HealthSensorPlatform.Presenter;

namespace EcgViewTest
{
    [TestFixture]
    public partial class EcgTest
    {
        /*
        [Test]
        public void CalculationTest()
        {
            double[] result;

            Form form = new Form();
            EcgView ecgView = new EcgView();
            int[] ecgData = new int[] { 0, 1000 << 6, 226759, 159111, 8388544, 8388608};

            form.Controls.Add(ecgView);
            result = ecgView.UpdateChart(EcgView.StreamDataType.Ecg, ecgData);

            // millivolts
            Assert.AreEqual(0, result[0], 1e-3);
            Assert.AreEqual(0.38147, result[1], 1e-3);
            Assert.AreEqual(1.351547, result[2], 1e-3);
            Assert.AreEqual(0.948334, result[3], 1e-2);
            Assert.AreEqual(49.99962, result[4], 1e-2);
            Assert.AreEqual(-50, result[5], 1e-2);
        }

        [Test]
        public void CalculationTest1()
        {
            double[] result;

            Form form = new Form();
            EcgView ecgView = new EcgView();
            int[] ecgData = new int[] { 226759, 159111, 8388544, 8388608 };

            form.Controls.Add(ecgView);
            result = ecgView.UpdateChart(EcgView.StreamDataType.Ecg, ecgData);

            // milliovolts
            Assert.AreEqual(1.351547, result[0], 1e-3);

        }
        */

        [Test]
        public void EcgCalculationTest()
        {
            EcgView ecgView = new EcgView();
            StreamPresenter sp = new StreamPresenter(ecgView);
            double[] result;
            int[] ecgData = new int[] { 0 | 7, 1000 << 6 | 7, 226759, 159119 | 7, 8388547 | 7, 8388607 | 7 };

            result = sp.ProcessEcg(ecgData);

            // millivolts
            Assert.AreEqual(0, result[0], 1e-3);
            Assert.AreEqual(ecgEquation(ecgData[1] >> 6), result[1], 1e-3);
            Assert.AreEqual(ecgEquation(ecgData[2] >> 6), result[2], 1e-3);
            Assert.AreEqual(ecgEquation(ecgData[3] >> 6), result[3], 1e-2);
            Assert.AreEqual(ecgEquation(ecgData[4] >> 6), result[4], 1e-2);
            Assert.AreEqual(ecgEquation(ecgData[5] >> 6), result[5], 1e-2);
        }

        double ecgEquation(double data)
        {
            return 1000 * 7.62939453125e-6 * data / 20;
        }

        /*

        [TestCase(0x80, 60)]
        [TestCase(0xff, 30.118)]
        [TestCase(0x01, 7680)]
        [TestCase(0xaa, 45.176)]
        public void RToRCalculationTest(int rToR, double bpm)
        {
            double result;

            EcgView ecgView = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgView.ecgArgs = ecgInit;

            result = ecgView.RToRBeatsPerMinute(rToR);

            Assert.AreEqual(bpm, result, 1e-2);
        }

        [TestCase(0x80, 58.594)]
        [TestCase(0xff, 29.412)]
        [TestCase(0x01, 7500)]
        [TestCase(0xaa, 44.1176)]
        public void RToRCalculationTest1(int rToR, double bpm)
        {
            double result;

            EcgView ecgView = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgView.ecgArgs = ecgInit;

            ecgView.FrequencyMasterField = 1;

            result = ecgView.RToRBeatsPerMinute(rToR);

            Assert.AreEqual(bpm, result, 1e-2);
        }

        [TestCase(0x80, 58.594)]
        [TestCase(0xff, 29.412)]
        [TestCase(0x01, 7500)]
        [TestCase(0xaa, 44.1176)]
        public void RToRCalculationTest2(int rToR, double bpm)
        {
            double result;

            EcgView ecgView = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgView.ecgArgs = ecgInit;

            ecgView.FrequencyMasterField = 2;

            result = ecgView.RToRBeatsPerMinute(rToR);

            Assert.AreEqual(bpm, result, 1e-2);
        }

        [TestCase(0x80, 58.535)]
        [TestCase(0xff, 29.382)]
        [TestCase(0x01, 7492.5)]
        [TestCase(0xaa, 44.0735)]
        public void RToRCalculationTest3(int rToR, double bpm)
        {
            double result;

            EcgView ecgView = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgView.ecgArgs = ecgInit;

            ecgView.FrequencyMasterField = 3;

            result = ecgView.RToRBeatsPerMinute(rToR);

            Assert.AreEqual(bpm, result, 1e-2);
        }
        */
    }
}
