﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using NUnit.Framework;
using RPCSupport.Devices;
using RPCSupport;

namespace RPCSupportTest
{
    [TestFixture, Property("Hardware", "Required")]
    public class MAX30205Test
    {
        RPCClient rpcClient;
        MAX30205 max30205;

        [TestFixtureSetUp]
        public void Init()
        {
            rpcClient = new RPCClient(RPCClient.ePipeline.eSerialWrap);
            rpcClient.InitPipeline();
            rpcClient.Connect(ComPort.Port);
            max30205 = rpcClient.Init_MAX30205(0x90);
        }

        [TestFixtureTearDown]
        public void Dispose()
        {
            rpcClient.Disconnect();
        }

        [Test]
        public void ReadTemperature()
        {
            float temp = max30205.ReadTemp();

            Assert.AreEqual(true, temp > 20 && temp < 30);
        }

        [Test]
        public void ReadConfigurationRegister()
        {
            byte data = max30205.ReadReg(0x01);

            Assert.AreEqual(true, data >= 0 && data <= 0xff);
        }

        [Test]
        public void WriteConfigurationRegister()
        {
            byte data = max30205.ReadReg(0x01);

            byte flipped = (byte)(data ^ 0xFF);

            max30205.WriteReg(0x01, flipped);

            byte result = max30205.ReadReg(0x01);

            max30205.WriteReg(0x01, data); // Restore register value

            Assert.AreEqual(flipped, result);
        }

        [Test]
        public void WriteOverTemperatureRegister()
        {
            Assert.AreEqual(true, false);
        }
    }
}