﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform
{
    /// <summary>
    /// This performs a FIR filter calculation on data provided to this class
    /// </summary>
    public class FirFilter
    {
        /// <summary>
        /// FIR filter coefficents
        /// </summary>
        public double[] Coefficents;
        /// <summary>
        /// Internal FIFO of previous data values
        /// </summary>
        Queue<int> buffer;

        public FirFilter()
        {
            double[] filterCoefficnets = new double[] {
                0.024885237	,
            -0.007653574	,
            -0.007907673	,
            -0.008893603	,
            -0.010461763	,
            -0.012494771	,
            -0.014895244	,
            -0.01757762	,
            -0.020462913	,
            -0.023475562	,
            -0.026541814	,
            -0.029589204	,
            -0.032546822	,
            -0.035346114	,
            -0.037922039	,
            -0.040214407	,
            -0.042169293	,
            -0.043740402	,
            -0.044890306	,
            -0.045591484	,
            0.954172901	,
            -0.045591484	,
            -0.044890306	,
            -0.043740402	,
            -0.042169293	,
            -0.040214407	,
            -0.037922039	,
            -0.035346114	,
            -0.032546822	,
            -0.029589204	,
            -0.026541814	,
            -0.023475562	,
            -0.020462913	,
            -0.01757762	,
            -0.014895244	,
            -0.012494771	,
            -0.010461763	,
            -0.008893603	,
            -0.007907673	,
            -0.007653574	,
            0.024885237
            };

            Coefficents = filterCoefficnets;

            buffer = new Queue<int>(Coefficents.Length);

            Reset();
        }

        /// <summary>
        /// FirFilter constructor. FIR data points initalized to zero.
        /// </summary>
        /// <param name="coefficents">FIR filter coefficents</param>
        public FirFilter(double[] coefficents)
        {
            Coefficents = coefficents;

            buffer = new Queue<int>(Coefficents.Length);

            Reset();
        }

        /// <summary>
        /// Reset filter internal state
        /// </summary>
        public void Reset()
        {
            buffer.Clear();

            // initialize values to zero
            for (int i = 0; i < Coefficents.Length; i++)
            {
                buffer.Enqueue(0);
            }
        }

        /// <summary>
        /// Compute the filtered value
        /// </summary>
        /// <param name="val">integer value to add to buffer for computation</param>
        /// <returns>filter output</returns>
        public double Compute(int val)
        {
            double result = 0;
            int[] values;

            buffer.Dequeue();
            buffer.Enqueue(val);
            values = buffer.ToArray();

            for (int i = 0; i < values.Length; i++)
            {
                result += Coefficents[i] * values[values.Length - i - 1]; 
            }

            return result;
        }
    }
}
