﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HealthSensorPlatform.DeviceDescriptions;
using RPCSupport.DeviceSupport;

namespace Maxim.CustomControls
{
    public class MAX30205Info : Device
    {

        public MAX30205Info()
        {
            deviceDetails = new DeviceDetails();
            deviceDetails.InitI2c(1, 0x90);

            initalizeDescription();

        }

        public MAX30205Info(byte i2cAddress)
        {
            deviceDetails = new DeviceDetails();
            deviceDetails.InitI2c(1, i2cAddress);

            initalizeDescription();
        }

        void initalizeDescription()
        {
            Info = new RegisterInfo[] {
                new RegisterInfo("TEMPERATURE",0x00,2),
                new RegisterInfo("CONFIGURATION",0x01),
                new RegisterInfo("T_HYST",0x02,2),
                new RegisterInfo("T_OS",0x03,2)
           };

            // register 0x00
            Descriptions(0x00).Add("Bit [15:0]", "TEMP", "Temperature Data");
            // register 0x01
            Descriptions(0x01).Add("Bit 7", "ONE-SHOT", "One-Shot");
            Descriptions(0x01).Add("Bit 6", "/TIMEOUT", "Timeout");
            Descriptions(0x01).Add("Bit 5", "DATA_FORMAT", "Data Format");
            Descriptions(0x01).Add("Bit 4", "FAULT_QUEUE[1]", "Fault Queue");
            Descriptions(0x01).Add("Bit 3", "FAULT_QUEUE[0]", "Fault Queue");
            Descriptions(0x01).Add("Bit 2", "OS_POLARITY", "OS Polarity");
            Descriptions(0x01).Add("Bit 1", "CMPRTR/INTRRPT", "Comparator and Interrupt");
            Descriptions(0x01).Add("Bit 0", "SHUTDOWN", "Shutdown");
            // register 0x02
            Descriptions(0x02).Add("Bit [15:0]", "T_HYST", "Hysteresis Set Point");
            // register 0x03
            Descriptions(0x03).Add("Bit [15:0]", "T_OS", "Overtemperature Shutdown Set Point");
        }
    }
}
