﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Globalization;

namespace HealthSensorPlatform.CustomControls
{
    public partial class PrimitivesView : UserControl
    {
        public PrimitivesView()
        {
            InitializeComponent();
        }

        public RPCSupport.RPCClient rpcClient { get; set; }
        public RPCSupport.Devices.I2cDevice i2cDevice { get; set; }
        public RPCSupport.Devices.SpiDevice spiDevice { get; set; }
        public RPCSupport.Devices.MAX30101 max30101 { get; set; }
        public RPCSupport.Devices.MAX30205 max30205 { get; set; }
        public RPCSupport.Devices.MAX30001 max30001 { get; set; }
        public RPCSupport.Devices.LIS2HD lis2hd { get; set; }

        private void PrimitivesView_Load(object sender, EventArgs e)
        {
 
        }

        private void btnRawRpcEnter_Click(object sender, EventArgs e)
        {
            String request = tbCommandLine.Text + "\r\n";
            String reply = rpcClient.RawRpcCall(request, true);
            //txt_Status.Text += request;
            //txt_Status.Text += reply + "\r\n";
        }

        private void btnI2cReadReg_Click(object sender, EventArgs e)
        {
            byte instance;
            byte slaveAddress;
            byte address;
            if (byte.TryParse(tbI2cInstance.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out instance))
            {
                if (byte.TryParse(tbI2cSlaveAddress.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out slaveAddress))
                {
                    if (byte.TryParse(tbI2cAddress.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
                    {
                        byte value = i2cDevice.ReadReg(instance, slaveAddress, address);
                        tbI2cReadData.Text = value.ToString("X2");
                    }
                }
            }
        }

        private void btnI2cWriteReg_Click(object sender, EventArgs e)
        {
            byte instance;
            byte slaveAddress;
            byte address;
            byte data;
            if (byte.TryParse(tbI2cInstance.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out instance))
            {
                if (byte.TryParse(tbI2cSlaveAddress.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out slaveAddress))
                {
                    if (byte.TryParse(tbI2cAddress.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
                    {
                        if (byte.TryParse(tbI2cWriteData.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out data))
                        {
                            i2cDevice.WriteReg(instance, slaveAddress, address, data);
                        }
                    }
                }
            }
        }

        private void btnMAX30101ReadReg_Click(object sender, EventArgs e)
        {
            byte address;
            if (byte.TryParse(tbMAX30101Address.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
            {
                byte value = max30101.ReadReg(address);
                tbMAX30101ReadData.Text = value.ToString("X2");
            }
        }

        private void btnSpiWriteReg_Click(object sender, EventArgs e)
        {
            byte data;
            byte address;
            if (byte.TryParse(tbMAX30101WriteData.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out data))
            {
                if (byte.TryParse(tbMAX30101Address.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
                {
                    max30101.WriteReg(address, data);
                }
            }
        }

        private void btnMAX30205ReadReg_Click(object sender, EventArgs e)
        {
            byte address;
            if (byte.TryParse(tbMAX30205Address.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
            {
                byte value = max30205.ReadReg(address);
                tbMAX30205ReadData.Text = value.ToString("X2");
            }
        }

        private void btnMAX30205WriteReg_Click(object sender, EventArgs e)
        {
            byte data;
            byte address;
            if (byte.TryParse(tbMAX30205WriteData.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out data))
            {
                if (byte.TryParse(tbMAX30205Address.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
                {
                    max30205.WriteReg(address, data);
                }
            }
        }

        private void btnLIS2HDReadReg_Click(object sender, EventArgs e)
        {
            byte address;
            if (byte.TryParse(tbLIS2HDAddress.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
            {
                byte value = lis2hd.ReadReg(address);
                tbLIS2HDReadData.Text = value.ToString("X2");
            }
        }

        private void btnLIS2HDWriteReg_Click(object sender, EventArgs e)
        {
            byte data;
            byte address;
            if (byte.TryParse(tbLIS2HDWriteData.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out data))
            {
                if (byte.TryParse(tbLIS2HDAddress.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
                {
                    lis2hd.WriteReg(address, data);
                }
            }
        }

        private void btnSpiReadReg_Click(object sender, EventArgs e)
        {

        }

        private void btnI2cWriteData_Click(object sender, EventArgs e)
        {

        }

        private void btnShowHideRpcLog_Click(object sender, EventArgs e)
        {
            if (rpcClient.IsRpcLogShown() == false)
            {
                rpcClient.ShowRpcLog(true);
                btnShowHideRpcLog.Text = "Hide RPC Log";
            }
            else
            {
                rpcClient.ShowRpcLog(false);
                btnShowHideRpcLog.Text = "Show RPC Log";
            }
        }

        private void btnMAX30001ReadReg_Click(object sender, EventArgs e)
        {
            byte address;
            if (byte.TryParse(tbMAX30001Address.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
            {
                int value = max30001.ReadReg(address);
                tbMAX30001ReadData.Text = value.ToString("X4");
            }
        }

        private void btnMAX30001WriteReg_Click(object sender, EventArgs e)
        {
            int data;
            byte address;
            if (int.TryParse(tbMAX30001WriteData.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out data))
            {
                if (byte.TryParse(tbMAX30001Address.Text, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out address))
                {
                    max30001.WriteReg(address, data);
                }
            }
        }

        /*
 
                 void LogRpcRequest(string request)
                {
                    txt_Status.Text += request;
                }

                void LogRpcReply(string reply)
                {
                    txt_Status.Text += reply + "\r\n";
                }

                private void txt_Status_TextChanged(object sender, EventArgs e)
                {
                    //Scroll to the bottom of the textbox when text is added
                    txt_Status.SelectionStart = txt_Status.Text.Length;
                    txt_Status.ScrollToCaret();
                    txt_Status.Refresh();
                }

                private void btn_Clear_Click(object sender, EventArgs e)
                {
                    //clear the status box
                    txt_Status.Text = "";
                }
         */

    }
}
