﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform.CustomControls
{
    /// <summary>
    /// Data for initializing streaming or flash logging
    /// </summary>
    public class InitArgs
    {
        interface IInitArgs
        {
            string ToCommandString();
            //IInitArgs FromIntArray(int[] array); 
        }

        public struct RbiasInit
        {
            public int En_rbias;
            public int Rbias;
            public int Rbiasp;
            public int Rbiasn;
            public int Fmstr;
        }

        public class EcgInitStart : IInitArgs
        {
            public int En_ecg;
            public int Openp;
            public int Openn;
            public int Pol;
            public int Calp_sel;
            public int Caln_sel;
            public int E_fit;
            public int Rate;
            public int Gain;
            public int Dhpf;
            public int Dlpf;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(En_ecg.ToString("X2")).Append(" ");
                command.Append(Openp.ToString("X2")).Append(" ");
                command.Append(Openn.ToString("X2")).Append(" ");
                command.Append(Pol.ToString("X2")).Append(" ");
                command.Append(Calp_sel.ToString("X2")).Append(" ");
                command.Append(Caln_sel.ToString("X2")).Append(" ");
                command.Append(E_fit.ToString("X2")).Append(" ");
                command.Append(Rate.ToString("X2")).Append(" ");
                command.Append(Gain.ToString("X2")).Append(" ");
                command.Append(Dhpf.ToString("X2")).Append(" ");
                command.Append(Dlpf.ToString("X2"));

                return command.ToString();
            }

            public int[] ToArray()
            {
                int[] array = new int[11];

                array[0] = En_ecg;
                array[1] = Openp;
                array[2] = Openn;
                array[3] = Pol;
                array[4] = Calp_sel;
                array[5] = Caln_sel;
                array[6] = E_fit;
                array[7] = Rate;
                array[8] = Gain;
                array[9] = Dhpf;
                array[10] = Dlpf;

                return array;
            }

            public EcgInitStart FromIntArray(int[] array)
            {
                if (array.Length == 11)
                {
                    En_ecg = array[0];
                    Openp = array[1];
                    Openn = array[2];
                    Pol = array[3];
                    Calp_sel = array[4];
                    Caln_sel = array[5];
                    E_fit = array[6];
                    Rate = array[7];
                    Gain = array[8];
                    Dhpf = array[9];
                    Dlpf = array[10];
                }
                else
                {
                    throw new InvalidOperationException("Array length incorrect");
                }

                return this;
            }
        } 

        public struct EcgFastInit
        {
            public int Clr_Fast;
            public int Fast;
            public int Fast_Th;
        }

        public class FMSTRInitStart : IInitArgs
        {
            public int En_rbias;
            public int Rbiasv;
            public int Rbiasp;
            public int Rbiasn;
            public int Fmstr;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(En_rbias.ToString("X2")).Append(" ");
                command.Append(Rbiasv.ToString("X2")).Append(" ");
                command.Append(Rbiasp.ToString("X2")).Append(" ");
                command.Append(Rbiasn.ToString("X2")).Append(" ");
                command.Append(Fmstr.ToString("X2"));

                return command.ToString();
            }

            public FMSTRInitStart FromIntArray(int[] array)
            {
                if (array.Length == 5)
                {
                    En_rbias = array[0];
                    Rbiasv = array[1];
                    Rbiasp = array[2];
                    Rbiasn = array[3];
                    Fmstr = array[4];
                }
                else
                {
                    throw new InvalidOperationException("Array length incorrect");
                }

                return this;
            }
        }

        public class PACEInitStart : IInitArgs
        {
            public int En_pace;
            public int Clr_pedge;
            public int Pol;
            public int Gn_diff_off;
            public int Gain;
            public int Aout_lbw;
            public int Aout;
            public int Dacp;
            public int Dacn;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(En_pace.ToString("X2")).Append(" ");
                command.Append(Clr_pedge.ToString("X2")).Append(" ");
                command.Append(Gn_diff_off.ToString("X2")).Append(" ");
                command.Append(Gain.ToString("X2")).Append(" ");
                command.Append(Aout_lbw.ToString("X2")).Append(" ");
                command.Append(Aout.ToString("X2")).Append(" ");
                command.Append(Dacp.ToString("X2")).Append(" ");
                command.Append(Dacn.ToString("X2"));

                return command.ToString();
            }

            public int[] ToArray()
            {
                int[] array = new int[9];

                array[0] = En_pace;
                array[1] = Clr_pedge;
                array[2] = Pol;
                array[3] = Gn_diff_off;
                array[4] = Gain;
                array[5] = Aout_lbw;
                array[6] = Aout;
                array[7] = Dacp;
                array[8] = Dacn;

                return array;
            }

            public PACEInitStart FromIntArray(int[] array)
            {
                if (array.Length == 8)
                {
                    En_pace = array[0];
                    Clr_pedge = array[1];
                    Pol = array[2];
                    Gn_diff_off = array[3];
                    Gain = array[4];
                    Aout_lbw = array[5];
                    Dacp = array[6];
                    Dacn = array[7];
                }
                else
                {
                    throw new InvalidOperationException("Array length incorrect");
                }

                return this;
            }
        }

        public class BIOZInitStart : IInitArgs
        {
            public int En_bioz;
            public int Openp;
            public int Openn;
            public int Calp_sel;
            public int Caln_sel;
            public int CG_mode;
            public int B_fit;
            public int Rate;
            public int Ahpf;
            public int Ext_rbias;
            public int Gain;
            public int Dhpf;
            public int Dlpf;
            public int Fcgen;
            public int Cgmon;
            public int Cgmag;
            public int Phoff;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(En_bioz.ToString("X2")).Append(" ");
                command.Append(Openp.ToString("X2")).Append(" ");
                command.Append(Openn.ToString("X2")).Append(" ");
                command.Append(Calp_sel.ToString("X2")).Append(" ");
                command.Append(Caln_sel.ToString("X2")).Append(" ");
                command.Append(CG_mode.ToString("X2")).Append(" ");
                command.Append(B_fit.ToString("X2")).Append(" ");
                command.Append(Rate.ToString("X2")).Append(" ");
                command.Append(Ahpf.ToString("X2")).Append(" ");
                command.Append(Ext_rbias.ToString("X2")).Append(" ");
                command.Append(Gain.ToString("X2")).Append(" ");
                command.Append(Dhpf.ToString("X2")).Append(" ");
                command.Append(Dlpf.ToString("X2")).Append(" ");
                command.Append(Fcgen.ToString("X2")).Append(" ");
                command.Append(Cgmon.ToString("X2")).Append(" ");
                command.Append(Cgmag.ToString("X2")).Append(" ");
                command.Append(Phoff.ToString("X2"));

                return command.ToString();
            }

            public int[] ToArray()
            {
                int[] array = new int[17];

                array[0] = En_bioz;
                array[1] = Openp;
                array[2] = Openn;
                array[3] = Calp_sel;
                array[4] = Caln_sel;
                array[5] = CG_mode;
                array[6] = B_fit;
                array[7] = Rate;
                array[8] = Ahpf;
                array[9] = Ext_rbias;
                array[10] = Gain;
                array[11] = Dhpf;
                array[12] = Dlpf;
                array[13] = Fcgen;
                array[14] = Cgmon;
                array[15] = Cgmag;
                array[16] = Phoff;

                return array;
            }

            public BIOZInitStart FromIntArray(int[] array)
            {
                if (array.Length == 17)
                {
                    En_bioz = array[0];
                    Openp = array[1];
                    Openn = array[2];
                    Calp_sel = array[3];
                    Caln_sel = array[4];
                    CG_mode = array[5];
                    B_fit = array[6];
                    Rate = array[7];
                    Ahpf = array[8];
                    Ext_rbias = array[9];
                    Gain = array[10];
                    Dhpf = array[11];
                    Dlpf = array[12];
                    Fcgen = array[13];
                    Cgmon = array[14];
                    Cgmag = array[15];
                    Phoff = array[16];
                }
                else
                {
                    throw new InvalidOperationException("Array size incorrect");
                }

                return this;
            }
        }

        public class RToRInitStart : IInitArgs
        {
            public int En_rtor;
            public int Wndw;
            public int Gain;
            public int Pavg;
            public int Ptsf;
            public int Hoff;
            public int Ravg;
            public int Rhsf;
            public int Clr_rrint;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(En_rtor.ToString("X2")).Append(" ");
                command.Append(Wndw.ToString("X2")).Append(" ");
                command.Append(Gain.ToString("X2")).Append(" ");
                command.Append(Pavg.ToString("X2")).Append(" ");
                command.Append(Ptsf.ToString("X2")).Append(" ");
                command.Append(Hoff.ToString("X2")).Append(" ");
                command.Append(Ravg.ToString("X2")).Append(" ");
                command.Append(Rhsf.ToString("X2")).Append(" ");
                command.Append(Clr_rrint.ToString("X2"));

                return command.ToString();
            }

            public int[] ToArray()
            {
                int[] array = new int[9];

                array[0] = En_rtor;
                array[1] = Wndw;
                array[2] = Gain;
                array[3] = Pavg;
                array[4] = Ptsf;
                array[5] = Hoff;
                array[6] = Ravg;
                array[7] = Rhsf;
                array[8] = Clr_rrint;

                return array;
            }

            public RToRInitStart FromIntArray(int[] array)
            {
                if (array.Length == 9)
                {
                    En_rtor = array[0];
                    Wndw = array[1];
                    Gain = array[2];
                    Pavg = array[3];
                    Ptsf = array[4];
                    Hoff = array[5];
                    Ravg = array[6];
                    Rhsf = array[7];
                    Clr_rrint = array[8];
                }
                else
                {
                    throw new InvalidOperationException("Array size incorrect");
                }

                return this;
            }
        }

        public struct CalInitStart
        {
            public int Vmode;
            public int Vmag;
            public int Fcal;
            public int Thigh;
            public int Fifty;
            public int En_Vcal;
        }

        public class SpO2HRModeInitStart : IInitArgs
        {
            public int FifoWaterlevelMark;
            public int SampleAverage;
            public int SampleRate;
            public int PulseWidth;
            public int RedLedCurrent;
            public int IRLedCurrent;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(FifoWaterlevelMark.ToString("X2")).Append(" ");
                command.Append(SampleAverage.ToString("X2")).Append(" ");
                command.Append(SampleRate.ToString("X2")).Append(" ");
                command.Append(PulseWidth.ToString("X2")).Append(" ");
                command.Append(RedLedCurrent.ToString("X2")).Append(" ");
                command.Append(IRLedCurrent.ToString("X2"));

                return command.ToString();
            }

            public SpO2HRModeInitStart FromIntArray(int[] array)
            {
                if (array.Length == 6)
                {
                    FifoWaterlevelMark = array[0];
                    SampleAverage = array[1];
                    SampleRate = array[2];
                    PulseWidth = array[3];
                    RedLedCurrent = array[4];
                    IRLedCurrent = array[5];
                }
                else if (array.Length == 5)
                {
                    FifoWaterlevelMark = array[0];
                    SampleAverage = array[1];
                    SampleRate = array[2];
                    PulseWidth = array[3];
                    RedLedCurrent = array[4];
                }
                else
                {
                    throw new InvalidOperationException("Array size incorrect");
                }

                return this;
            }
        }

        public class HRModeInitStart : IInitArgs
        {
            public int FifoWaterlevelMark;
            public int SampleAverage;
            public int SampleRate;
            public int PulseWidth;
            public int RedLedCurrent;
            public int IRLedCurrent;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(FifoWaterlevelMark.ToString("X2")).Append(" ");
                command.Append(SampleAverage.ToString("X2")).Append(" ");
                command.Append(SampleRate.ToString("X2")).Append(" ");
                command.Append(PulseWidth.ToString("X2")).Append(" ");
                command.Append(RedLedCurrent.ToString("X2"));

                return command.ToString();
            }

            public HRModeInitStart FromIntArray(int[] array)
            {
                if (array.Length == 5)
                {
                    FifoWaterlevelMark = array[0];
                    SampleAverage = array[1];
                    SampleRate = array[2];
                    PulseWidth = array[3];
                    RedLedCurrent = array[4];
                }
                else
                {
                    throw new InvalidOperationException("Array size incorrect");
                }

                return this;
            }
        }

        public class MultiModeInitStart : IInitArgs
        {
            public int FifoWaterlevelMark;
            public int SampleAverage;
            public int SampleRate;
            public int PulseWidth;
            public int RedLedCurrent;
            public int IRLedCurrent;
            public int GreenLedCurrent;
            public int Slot1;
            public int Slot2;
            public int Slot3;
            public int Slot4;

            public string ToCommandString()
            {
                StringBuilder command = new StringBuilder();
                command.Append(FifoWaterlevelMark.ToString("X2")).Append(" ");
                command.Append(SampleAverage.ToString("X2")).Append(" ");
                command.Append(SampleRate.ToString("X2")).Append(" ");
                command.Append(PulseWidth.ToString("X2")).Append(" ");
                command.Append(RedLedCurrent.ToString("X2")).Append(" ");
                command.Append(IRLedCurrent.ToString("X2")).Append(" ");
                command.Append(GreenLedCurrent.ToString("X2")).Append(" ");
                command.Append(Slot1.ToString("X2")).Append(" ");
                command.Append(Slot2.ToString("X2")).Append(" ");
                command.Append(Slot3.ToString("X2")).Append(" ");
                command.Append(Slot4.ToString("X2"));

                return command.ToString();
            }

            public MultiModeInitStart FromIntArray(int[] array)
            {
                if (array.Length == 11)
                {
                    FifoWaterlevelMark = array[0];
                    SampleAverage = array[1];
                    SampleRate = array[2];
                    PulseWidth = array[3];
                    RedLedCurrent = array[4];
                    IRLedCurrent = array[5];
                    GreenLedCurrent = array[6];
                    Slot1 = array[7];
                    Slot2 = array[8];
                    Slot3 = array[9];
                    Slot4 = array[10];
                }
                else
                {
                    throw new InvalidOperationException("Array size incorrect");
                }

                return this;
            }
        }
    }
}
