﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HealthSensorPlatform.View
{
    public interface IFormView
    {
        /// <summary>
        /// Occurs when view requests file logging to be enabled or disabled
        /// </summary>
        event EventHandler<EnableEventArgs> FileLogEnable;

        event EventHandler<EventArgs> RegisterExport;
        event EventHandler<EventArgs> RegisterImport;

        event EventHandler<EventArgs> Connected;

        /// <summary>
        /// Read all device registers and update the UI to reflect what is set in the devices
        /// </summary>
        void UpdateRegisters();

        /// <summary>
        /// Occurs when user requests manual register reads and writes
        /// </summary>
        //event EventHandler<EnableEventArgs> RegisterAccess;

        /// <summary>
        /// Set view to show file logging is enabled or disabled
        /// </summary>
        /// <param name="state"></param>
        void LogFileItem(StreamType stream, bool state);

        void OpticalLogFileItem(bool state);
        void EcgLogFileItem(bool state);
        void RtoRLogFileItem(bool state);
        void BioZLogFileItem(bool state);
        void PaceLogFileItem(bool state);

        /// <summary>
        /// Display messages on the view
        /// </summary>
        /// <param name="msg"></param>
        void MessageInfo(string msg);
        /// <summary>
        /// Display version information of firmware
        /// </summary>
        /// <param name="msg"></param>
        //void VersionInfo(string msg);
        /// <summary>
        /// Display connection information on the view
        /// </summary>
        /// <param name="msg"></param>
        //void ConnectionInfo(string msg);

        void MessageBoxShow(string msg);
        void MessageBoxShow(string msg, string title);

    }
}
