﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using Maxim.Utility;
using HealthSensorPlatform.Model;

namespace HealthSensorPlatform.View
{
    class RawFileLogView : FileLog, IRawFileLogView
    {
        /* Fields */
        private bool enable = false;
        //private double sampleRate = 0;
        //private int count = 0;

        /* Constructors */

        /* Events */
        public new event EventHandler<Maxim.Global.ErrorEventArgs> Error;

        /* Properties */
        public bool Enable
        {
            get
            {
                return enable;
            }
            set
            {
                enable = value;
                if (enable == false)
                    Close();
            }
        }

        /* Methods */
        public void StreamStartStop()
        {
        }

        public void DisplayEcg(double[] time, EcgFifo[] ecgData)
        {
            DisplayEcg(time, ecgData, null);
        }

        public void DisplayEcg(double[] time, EcgFifo[] ecgData, DCLeadOff leadOff)
        {
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < ecgData.Length; i++)
            {
                sb.Append(time[i]);
                sb.Append(", ");
                sb.Append(ecgData[i].EcgData);
                sb.Append(", ");
                sb.Append(ecgData[i].ETag);
                sb.Append(", ");
                sb.Append(ecgData[i].PTag);
                sb.Append(", ");
                sb.Append(ecgData[i].Data);
                sb.Append(", ");

                if (leadOff != null)
                {
                    sb.Append(leadOff.PostiveHigh ? 1 : 0); 
                    sb.Append(", ");
                    sb.Append(leadOff.PostiveLow ? 1 : 0); 
                    sb.Append(", ");
                    sb.Append(leadOff.NegativeHigh ? 1 : 0);
                    sb.Append(", ");
                    sb.Append(leadOff.NegativeLow ? 1 : 0);
                }


                if (i != ecgData.Length - 1)
                    sb.Append(Environment.NewLine);
            }

            WriteLine(sb.ToString());

        }

        public void DisplayBioZ(double[] time, BioZFifo[] bioZData)
        {
            DisplayBioZ(time, bioZData, null, null);
        }

        public void DisplayBioZ(double[] time, BioZFifo[] bioZData, DCLeadOff leadOff)
        {
            DisplayBioZ(time, bioZData, leadOff, null);
        }

        public void DisplayBioZ(double[] time, BioZFifo[] bioZData, ACLeadOff acLeadOff)
        {
            DisplayBioZ(time, bioZData, null, acLeadOff);
        }

        public void DisplayBioZ(double[] time, BioZFifo[] bioZData, DCLeadOff leadOff, ACLeadOff acLeadOff)
        {
             StringBuilder sb = new StringBuilder();

            for (int i = 0; i < bioZData.Length; i++)
            {
                sb.Append(time[i]);
                sb.Append(", ");
                sb.Append(bioZData[i].BioZData);
                sb.Append(", ");
                sb.Append(bioZData[i].BTag);
                sb.Append(", ");
                sb.Append(bioZData[i].Data);
                sb.Append(", ");

                if (leadOff != null)
                {
                    sb.Append(leadOff.PostiveHigh ? 1 : 0);
                    sb.Append(", ");
                    sb.Append(leadOff.PostiveLow ? 1 : 0);
                    sb.Append(", ");
                    sb.Append(leadOff.NegativeHigh ? 1 : 0);
                    sb.Append(", ");
                    sb.Append(leadOff.NegativeLow ? 1 : 0);
                    sb.Append(", ");
                }
                else
                    sb.Append(", , , ,");

                if (acLeadOff != null)
                {
                    sb.Append(acLeadOff.BioZOverRange ? 1 : 0);
                    sb.Append(", ");
                    sb.Append(acLeadOff.BioZUnderRange ? 1 : 0);
                    sb.Append(", ");
                }

                if (i != bioZData.Length - 1)
                    sb.Append(Environment.NewLine);
            }

            WriteLine(sb.ToString());

        }

        public void DisplayRToR(int rToRData, double rToRCorrectedSeconds)
        {
            StringBuilder sb = new StringBuilder();

            sb.Append(rToRData);
            sb.Append(", ");
            sb.Append(rToRCorrectedSeconds);

            WriteLine(sb.ToString());
        }

        public void DisplayPace(double[] time, PaceData.PaceEdge[] paceData)
        {
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < time.Length; i++)
            {
                sb.Append(time[i]);
                sb.Append(", ");
                sb.Append(paceData[i].Data);
                sb.Append(", ");
                sb.Append(paceData[i].Polarity ? 'R' : 'F');
                sb.Append(", ");
                sb.Append(paceData[i].Last ? '1' : '0');

                if (i != time.Length - 1)
                    sb.Append(Environment.NewLine);

            }

            WriteLine(sb.ToString());
        }

        public void DisplayPressure(int[] hexTemperature, double[] temperature, int[] hexPressure, double[] pressure)
        {
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < hexTemperature.Length; i++)
            {
                sb.Append(hexTemperature[i]);
                sb.Append(", ");
                sb.Append(temperature[i]);
                sb.Append(", ");
                sb.Append(hexPressure[i]);
                sb.Append(", ");
                sb.Append(pressure[i]);
                sb.Append(", ");

                if (i != hexTemperature.Length - 1)
                    sb.Append(Environment.NewLine);
            }

            WriteLine(sb.ToString());
        }

        public void DisplayTemperature(int[] hex, double[] temperature)
        {
            StringBuilder sb = new StringBuilder();

            for (int i = 0; i < hex.Length; i++)
            {
                sb.Append(hex[i]);
                sb.Append(", ");
                sb.Append(temperature[i].ToString("F3"));

                if (i != hex.Length - 1)
                    sb.Append(Environment.NewLine);
            }

            WriteLine(sb.ToString());
        }

        public void DisplayPpg(double[] time, int[][] data)
        {
            StringBuilder strBuilder = new StringBuilder();

            int channelCount = 0;

            int[] data1 = data[0];
            int[] data2 = data[1];
            int[] data3 = data[2];
            //int[] data4 = data[3];

            //if (data4.Length != 0)
            //    channelCount = 4;
            if (data3.Length != 0)
                channelCount = 3;
            else if (data2.Length != 0)
                channelCount = 2;
            else if (data1.Length != 0)
                channelCount = 1;

            for (int i = 0; i < data1.Length; i++)
            {
                strBuilder.Append(time[i]);
                strBuilder.Append(",");
                for (int j = 0; j < channelCount; j++)
                {
                    //strBuilder.Append(data[j][i] & 0x7FFFF); // Data Code
                    //strBuilder.Append(",");
                    //strBuilder.Append(data[j][i] >> 19); // DAC code
                    //strBuilder.Append(data[j][i] & 0x7FFFF); // Data Code
                    strBuilder.Append(data[j][i]);
                    strBuilder.Append(",");
                }
                WriteLine(strBuilder.ToString());
                strBuilder.Clear();
            }
        }

        public void DisplayPpg(int[][] data)
        {
            long time = DateTime.Now.Ticks;
            long startTime = DateTime.Now.Ticks;
            string timeStr;
            StringBuilder strBuilder = new StringBuilder();

            int channelCount = 0;

            //string datetime = string.Format("{0:HH-mm-ss.fff}", DateTime.Now) + ", "; 
            timeStr = ((time - startTime) / 10000000.0).ToString() + ", ";

            int[] data1 = data[0];
            int[] data2 = data[1];
            int[] data3 = data[2];
            //int[] data4 = data[3];

            //if (data4.Length != 0)
            //    channelCount = 4;
            if (data3.Length != 0)
                channelCount = 3;
            else if (data2.Length != 0)
                channelCount = 2;
            else if (data1.Length != 0)
                channelCount = 1;

            for (int i = 0; i < data1.Length; i++)
            {
                strBuilder.Append(timeStr);
                for (int j = 0; j < channelCount; j++)
                {
                    //strBuilder.Append(data[j][i] & 0x7FFFF); // Data Code
                    //strBuilder.Append(",");
                    //strBuilder.Append(data[j][i] >> 19); // DAC code
                    //strBuilder.Append(data[j][i] & 0x7FFFF); // Data Code
                    strBuilder.Append(data[j][i]);
                    strBuilder.Append(",");
                }
                WriteLine(strBuilder.ToString());
                strBuilder.Clear();
            }

        }

        public void DisplayXYZ(double[] time, int[][] data)
        {
            StringBuilder strBuilder = new StringBuilder();

            int[] data1 = data[0];
            int[] data2 = data[1];
            int[] data3 = data[2];
            //int[] data4 = data[3];

            for (int i = 0; i < data3.Length; i++)
            {
                strBuilder.Append(time[i]);
                strBuilder.Append(",");
                strBuilder.Append(data[0][i]);
                strBuilder.Append(",");
                strBuilder.Append(data[1][i]);
                strBuilder.Append(",");
                strBuilder.Append(data[2][i]);

                WriteLine(strBuilder.ToString());
                strBuilder.Clear();
            }
        }

        public void DisplayXYZ(int[][] data)
        {
            long time = DateTime.Now.Ticks;
            long startTime = DateTime.Now.Ticks;
            string timeStr;
            StringBuilder strBuilder = new StringBuilder();

            //string datetime = string.Format("{0:HH-mm-ss.fff}", DateTime.Now) + ", "; 
            timeStr = ((time - startTime) / 10000000.0).ToString() + ", ";

            int[] data1 = data[0];
            int[] data2 = data[1];
            int[] data3 = data[2];
            //int[] data4 = data[3];

            for (int i = 0; i < data3.Length; i++)
            {
                strBuilder.Append(time);
                strBuilder.Append(data[0][i]);
                strBuilder.Append(",");
                strBuilder.Append(data[1][i]);
                strBuilder.Append(",");
                strBuilder.Append(data[2][i]);

                WriteLine(strBuilder.ToString());
                strBuilder.Clear();
            }
        }
    }
}
