﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Collections;

namespace HealthSensorPlatform
{
    class Streaming
    {
        BackgroundWorker _testWorker;

        public ArrayList ArrayListRed = new ArrayList();
        public ArrayList ArrayListIR = new ArrayList();
        public ArrayList ArrayListGreen = new ArrayList();
        public event EventHandler<PartialArrayIntAvailableEventArgs> PartialArrayIntAvailable;

        public void Init()
        {
            _testWorker = new BackgroundWorker();
            _testWorker.WorkerSupportsCancellation = true;
            _testWorker.ProgressChanged += new ProgressChangedEventHandler(_testWorker_ProgressChanged);
            _testWorker.DoWork += new DoWorkEventHandler(_testWorker_DoWork);
            _testWorker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(_testWorker_RunWorkerCompleted);
            _testWorker.WorkerReportsProgress = true;
        }

        protected virtual void OnPartialArrayIntAvailable(PartialArrayIntAvailableEventArgs e)
        {
            EventHandler<PartialArrayIntAvailableEventArgs> handler = PartialArrayIntAvailable;
            if (handler != null)
            {
                handler(this, e);
            }
        }

        public void Start()
        {
            ArrayListRed.Clear();
            ArrayListIR.Clear();
            ArrayListGreen.Clear();
            _testWorker.RunWorkerAsync();
        }
        public void Stop()
        {
            _testWorker.CancelAsync();
        }
        void _testWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            var data = (System.Tuple<int, int, int[], int[], int[]>)(e.UserState);
            int reportID = data.Item1;
            int sampleNumberOffset = data.Item2;
            int[] list1_Red___or_X = data.Item3;
            int[] list2_IR____or_Y = data.Item4;
            int[] list3_Green_or_Z = data.Item5;

            for (int index = 0; index < list1_Red___or_X.Length; index++)
            {
                ArrayListRed.Add(list1_Red___or_X[index]);
            }
            for (int index = 0; index < list2_IR____or_Y.Length; index++)
            {
                ArrayListIR.Add(list2_IR____or_Y[index]);
            }
            for (int index = 0; index < list3_Green_or_Z.Length; index++)
            {
                ArrayListGreen.Add(list3_Green_or_Z[index]);
            }

            // https://jira.maxim-ic.com/browse/OS24EVK-59 matlab: PartialArrayIntAvailable based on PartialDataBufferAvailable of r14194 (broken)
            // https://jira.maxim-ic.com/browse/OS24EVK-59 matlab: What about using System.Array<int> instead of System.Collections.ArrayList?
            // https://jira.maxim-ic.com/browse/OS24EVK-59 matlab: Changed PartialDataBufferAvailableEventArgs and FinalDataBufferAvailableEventArgs to use int[] rawRedData, int[] rawIRData, int[] rawGreenData
            // int[] RawRedData replaces ArrayList ArrayListRed
            // example: https://jira.maxim-ic.com/browse/OS24EVK-59 standard event handler: Fire the PartialArrayIntAvailable event
            OnPartialArrayIntAvailable(new PartialArrayIntAvailableEventArgs()
            {
                sampleNumberOffset = sampleNumberOffset,
                rawRedData = (int[])ArrayListRed.ToArray(typeof(int)),
                rawIRData = (int[])ArrayListIR.ToArray(typeof(int)),
                rawGreenData = (int[])ArrayListGreen.ToArray(typeof(int))
            });
        }
        private void _testWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            while (true)
            {
                if (_testWorker.CancellationPending)
                {
                    return;
                }
            }
        }
        void _testWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
        }
    }
}
