﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using HealthSensorPlatform.CustomControls;

namespace HealthSensorPlatform.Presenter
{
    class EcgDelay
    {
        public const int RToRMaxValue = 0x3FFF;

        List<double> ecg;
        List<string> pace;
        List<double> rToR;

        //bool enableEcg;
        //bool enablePace;
        bool enableRToR;

        int offset;

        RToRCalculator rToRCalculator;

        bool firstRToR = true;

        public EcgDelay(bool enableRToR, int fmstr, int ecgSampleRate, int dlpf, int rWndw)
        {
            ecg = new List<double>();
            pace = new List<string>();
            rToR = new List<double>();

            this.enableRToR = enableRToR;

            rToRCalculator = new RToRCalculator(fmstr, ecgSampleRate, dlpf, rWndw);

            offset = rToRCalculator.EcgPoints(0, true) * -1;
        }

        public void AddEcg(double[] ecgVoltage)
        {
            ecg.AddRange(ecgVoltage);
        }

        public void AddPace(string[] paceLog)
        {
            pace.AddRange(paceLog);
        }

        public void AddRToR(int rToRRaw)
        {
            int rToREcg;

            if (firstRToR)
            {
                rToREcg = rToRCalculator.EcgPoints(rToRRaw, true);
                firstRToR = false;
            }
            else
            {
                rToREcg = rToRCalculator.EcgPoints(rToRRaw, false);
            }

            for (int i = 1; i < rToREcg; i++)
            {
                rToR.Add(0);
            }

            if (rToRRaw != RToRMaxValue)
                rToR.Add(rToRCalculator.Millisecond(rToRRaw));
            else
                rToR.Add(0);
        }

        public bool HasData()
        {
            if (enableRToR)
                return offset + 10 < rToR.Count;
            else
                return offset + 10 < ecg.Count;
        }

        public bool HasFinalData()
        {
            return ecg.Count > 0;
        }

        public Tuple<double[], string[], double[]> GetEcg()
        {
            double[] ecgVoltage;
            string[] paceGroup;
            double[] rToRInterval;

            int size;

            if (enableRToR)
                size = rToR.Count - offset - 10;
            else
                size = ecg.Count; // No delay needed if R To R is disabled, dump all points


            ecgVoltage = new double[size];
            paceGroup = new string[size];
            rToRInterval = new double[size];

            for (int i = 0; i < size; i++ )
            {
                ecgVoltage[i] = ecg[i];
                paceGroup[i] = pace[i];
                if (enableRToR)
                    rToRInterval[i] = rToR[i];
            }

            ecg.RemoveRange(0, size);
            pace.RemoveRange(0, size);
            if (enableRToR)
                rToR.RemoveRange(0, size);

            return new Tuple<double[],string[],double[]>(ecgVoltage, paceGroup, rToRInterval);
        }

        public Tuple<double[], string[], double[]> GetAllEcg()
        {
			double[] rToRZeroData = new double[ecg.Count];

            for (int i = 0; i < rToR.Count; i++)
                rToRZeroData[i] = rToR[i];

            return new Tuple<double[], string[], double[]>(ecg.ToArray(), pace.ToArray(), rToRZeroData);
        }
    }
}
