﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using MAX30205EVKit.Model;
using RPCSupport.Devices;

namespace HealthSensorPlatform.Model
{
    class MAX30205Model : ITemperatureModel
    {
        private I2cDevice i2cDevice; 
        private 
        byte i2cAddress;
        int[] registers = new int[4];

        public MAX30205Model(I2cDevice i2cDevice, byte i2cAddress)
        {
            this.i2cDevice = i2cDevice;
            this.i2cAddress = i2cAddress;
        }

                /* Properties */
        public bool DataFormat
        {
            get
            {
                return ((registers[1] >> 5) & 0x01) == 0x01 ? true : false;
            }
        }

        public int[] Registers
        {
            get
            {
                return registers;
            }
        }

        public void RegWrite(int regAddress, int regValue)
        {

            if ((regAddress == 0x02 || regAddress == 0x03))
            {
                //base.RegWrite(regAddress, new byte[] { (byte)((regValue >> 8) & 0xFF), (byte)(regValue & 0xFF) });
                i2cDevice.WriteRead(1, i2cAddress, new byte[] { (byte)regAddress, (byte)((regValue >> 8) & 0xFF), (byte)(regValue & 0xFF) }, 0);
            }
            else
            {
                //base.RegWrite(regAddress, regValue);
                i2cDevice.WriteReg(1, i2cAddress, (byte)regAddress, (byte)regValue);
            }


            System.Diagnostics.Debug.Print("RegWrite: " + regAddress.ToString("X2") + " " + regValue.ToString("X4"));
        }

        public int RegRead(int regAddress)
        {
            int result;
            byte[] readResult;

            switch (regAddress)
            {
                case 0x00:
                case 0x02:
                case 0x03:
                    readResult = i2cDevice.ReadMultiReg(1, (byte)i2cAddress, (byte)regAddress, 2);//base.RegRead(regAddress, 2);
                    result = readResult[0] << 8 | readResult[1];
                    break;
                default:
                    result = i2cDevice.ReadReg(1, (byte)i2cAddress, (byte)regAddress); //base.RegRead(regAddress, 1);
                    break;
            }

            registers[regAddress] = result;

            System.Diagnostics.Debug.Print("RegRead: " + regAddress.ToString("X2") + " " + result.ToString("X4"));

            return result;
        }
    }
}
