﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform
{
    public partial class HspForm
    {
        List<RegisterField> bioZLoadField = new List<RegisterField>();

        void initalizeBioZLoadFields()
        {
            string[] enBistOptions = { "Disabled*", "Enabled" };
            string[] rmodOptions = { "SWMOD0 Switch Closed", "SWMOD1 Switch Closed", "SWMOD2 Switch Closed", "SWMOD3 Switch Closed", "Not Modulated*" };
            string[] fbistOptions = { "FMSTR/2^13 (~4 Hz)*", "FMSTR/2^15 (~1 Hz)", "FMSTR/2^17 (~1/4 Hz)", "FMSTR/2^19 (~1/16 Hz)" };
            string[] rnomOptions = { "5000 Ω*", "2500 Ω", "1667 Ω", "1250 Ω", "1000 Ω", "833 Ω", "714 Ω", "625 Ω" };

            RegisterField enBistField = new RegisterField { Name = "BMUX_EN_BIST", Register = 0x17, Index = 11, Width = 1, Descriptions = enBistOptions, Label = lblBioZBmuxEnBist, Control = cboBioZBmuxEnBist, Device = max30001 };
            RegisterField rnomField = new RegisterField { Name = "BMUX_RNOM", Register = 0x17, Index = 8, Width = 3, Descriptions = rnomOptions, Label = lblBioZBmuxRnom, Control = cboBioZBmuxRnom, Device = max30001 };
            RegisterField rmodField = new RegisterField { Name = "BMUX_RMOD", Register = 0x17, Index = 4, Width = 3, Descriptions = rmodOptions, Label = lblBioZBmuxRmod, Control = cboBioZBmuxRmod, Device = max30001 };
            RegisterField fbistField = new RegisterField { Name = "BMUX_FBIST", Register = 0x17, Index = 0, Width = 2, Descriptions = fbistOptions, Label = lblBioZBmuxFbist, Control = cboBioZBmuxFbist, Device = max30001 };

            bioZLoadField.Add(enBistField);
            bioZLoadField.Add(rmodField);
            bioZLoadField.Add(fbistField);
            bioZLoadField.Add(rnomField);

            

        }

        private void UpdateBioZLoadSwitches()
        {
            //BioZ Load tab switch state reflects the BioZMux tab switch state

            //Lead Off Check
            if (picBioZLloff1.Image != null)
                picBioZLloff1.Image.Dispose();
            if (picBioZLloff2.Image != null)
                picBioZLloff2.Image.Dispose();
            if (picLoff1.Image != null)
            {
                picBioZLloff1.Image = Properties.Resources.bioz_loadloff1;
            }
            else
            {
                picBioZLloff1.Image = null;
            }
            if (picLoff2.Image != null)
            {
                picBioZLloff2.Image = Properties.Resources.bioz_loadloff2;
            }
            else
            {
                picBioZLloff2.Image = null;
            }

            //Lead On Check
            if (picBioZLlon.Image != null)
                picBioZLlon.Image.Dispose();
            if (picLeadOn.Image != null)
            {
                picBioZLlon.Image = Properties.Resources.bioz_load_leadon;
            }
            else
            {
                picBioZLlon.Image = null;
            }

            //Switches
            if (picBioZLsw1.Image != null)
                picBioZLsw1.Image.Dispose();
            if (picBioZLsw2.Image != null)
                picBioZLsw2.Image.Dispose();
            if (picBioZsw1.Image != null)
            {
                picBioZLsw1.Image = Properties.Resources.bioz_load_sw1;
            }
            else
            {
                picBioZLsw1.Image = null;
            }
            if (picBioZsw2.Image != null)
            {
                picBioZLsw2.Image = Properties.Resources.bioz_load_sw2;
            }
            else
            {
                picBioZLsw2.Image = null;
            }

            //Lead Bias
            if (picBioZLlb1.Image != null)
                picBioZLlb1.Image.Dispose();
            if (picBioZLlb2.Image != null)
                picBioZLlb2.Image.Dispose();
            if (picLeadBias1.Image != null)
            {
                picBioZLlb1.Image = Properties.Resources.bioz_load_lb1;
            }
            else
            {
                picBioZLlb1.Image = null;
            }
            if (picLeadBias2.Image != null)
            {
                picBioZLlb2.Image = Properties.Resources.bioz_load_lb2;
            }
            else
            {
                picBioZLlb2.Image = null;
            }

            //Calibration
            if (picBioZLcal1.Image != null)
            {
                picBioZLcal1.Image.Dispose();
                picBioZLcal1.Image = Properties.Resources.bioz_load_cal1;
            }
            else
            {
                picBioZLcal1.Image = null;
            }
            if (picBioZLcal2.Image != null)
            {
                picBioZLcal2.Image.Dispose();
                picBioZLcal2.Image = Properties.Resources.bioz_load_cal2;
            }
            else
            {
                picBioZLcal2.Image = null;
            }

            //Resistive Load Enable Logic
            if (picBioZLresload.Image != null)
                picBioZLresload.Image.Dispose();
            if (cboBioZBmuxEnBist.SelectedIndex == 1)
            {
                picBioZLresload.Image = Properties.Resources.bioz_load_resload;
            }
            else
            {
                picBioZLresload.Image = null;
            }
        }

        void BioZLoadUpdateRegisters()
        {
            internalUpdate = true;
            ReadComboBoxesRegisters(bioZLoadField);
            //UpdateBioZLoadSwitches(); moved to Form1.cs BioZLoad tab selection section
            internalUpdate = false;
        }

        private void cboBioZBmuxEnBist_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateBioZLoadSwitches();
        }

    }
}
