﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Windows.Forms;
using System.Runtime.InteropServices;


namespace Maxim.MAX30101GUI
{
    public static class SKA  // Steve Koh Algorithm
    {
        [DllImport("SKA.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true)]
        private static extern void processIrRed_R5_initialize();
        [DllImport("SKA.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true)]
        private static extern void processIrRed_R5_terminate();
        [DllImport("SKA.dll", CallingConvention = CallingConvention.Cdecl, SetLastError = true)]
        internal static extern void processIrRed_R5(int lapsedSecond, int[] irBuf, int[] redBuf, ref int HR, ref float SPO2, ref bool SPO2valid, ref bool HRvalid, ref float SPO2errorStatus, float[] IrBuffer_filtered_ac, float[] redBuffer_filtered_ac);

        static public void SKA_init()
        {
            try
            {
                processIrRed_R5_initialize();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message + Environment.NewLine + new System.Diagnostics.StackFrame().GetMethod().Name);
            }
        }

        static public void SKA_term()
        {
            try
            {
                processIrRed_R5_terminate();
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message + Environment.NewLine + new System.Diagnostics.StackFrame().GetMethod().Name);
            }
        }

        static public void SKA_work(int lapsedSecond, int[] irBuf, int[] redBuf, ref int HR, ref float SPO2, ref bool SPO2valid, ref bool HRvalid, ref float SPO2error, float[] IrBuffer_filtered_ac, float[] redBuffer_filtered_ac)
        {
            try
            {
                processIrRed_R5(lapsedSecond, irBuf, redBuf, ref HR, ref SPO2, ref SPO2valid, ref HRvalid, ref SPO2error, IrBuffer_filtered_ac, redBuffer_filtered_ac);
            }
            catch (Exception ex)
            {
                throw new Exception(ex.Message + Environment.NewLine + new System.Diagnostics.StackFrame().GetMethod().Name);
            }
        }
    }
}
