﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace RPCSupport.Devices
{
    public class Testing : ClientDevice
    {
        const string CLASSNAME = "Testing";
        public Testing(RPCClient client)
            : base(client)
        {
        }
        private String ProcessStrResult(String result)
        {
            String processed = result.Replace("|", "\r\n");
            String processed2 = processed.Substring(0,processed.Length-4);
            return processed2.Trim(new char[] { '\r', '\n', '|', ' ' });
        }
        private Boolean ProcessStrPassFail(String result)
        {
            Boolean bResult = false;
            int index = result.IndexOf("Result: ");
            String str = result.Substring(index + 8, 4).ToUpper();
            if (str.CompareTo("PASS") == 0) return true; else return false;
            return bResult;
        }
        public bool Test_S25FS512(out String strResult)
        {
            String testStr = "Testing S25FS512|ReadId: 23021F = Good|Format Sector 0 Test: Pass|Write Page 0 Test: Pass|Result: Pass";
            //Boolean resultTest = ProcessStrPassFail(testStr);
            //String processedStr = ProcessStrResult(testStr);
            String result = Call(CLASSNAME, "Test_S25FS512");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_BMP280(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_BMP280");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_LIS2DH(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_LIS2DH");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_LSM6DS3(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_LSM6DS3");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_MAX31725_1(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_MAX31725_1");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_MAX31725_2(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_MAX31725_2");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_MAX30101(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_MAX30101");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_MAX30001(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_MAX30001");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
        public bool Test_EM9301(out String strResult)
        {
            String result = Call(CLASSNAME, "Test_EM9301");
            strResult = ProcessStrResult(result);
            return ProcessStrPassFail(result);
        }
    }
}
