﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Globalization;
using System.Threading;

namespace RPCSupport.Devices
{
    /* ECG */
    public class MAX30001 : ClientDevice, IRegisterDevice
    {

        public enum max30001_intrpt_Location {
            MAX30001_NO_INT  = 0,  // No interrupt
            MAX30001_INT_B   = 1,  // INTB selected for interrupt
            MAX30001_INT_2B  = 2,   // INT2B selected for interrupt
            test1 = 3,
            test2 = 4,
            test3 = 5,
            test4 = 6,
            test5 = 7,
            test6 = 8,
            test7 = 9,
            test8 = 10,
            test9 = 11,
            test10 = 12,
            test11 = 13,
            test12 = 14,
            test13 = 15,
            test14 = 16,
            test15 = 17
        };

        public enum max30001_intrpt_type {
	        MAX30001_INT_DISABLED = 0x00,
	        MAX30001_INT_CMOS     = 0x01,
	        MAX30001_INT_ODN      = 0x02,
            MAX30001_INT_ODNR     = 0x03,
	        test1     = 18,   
	        test2     = 19
        };

        public const string CLASSNAME = "MAX30001";
        public MAX30001(RPCClient client)
            : base(client)
        {
        }
        public int ReadReg(byte addr)
        {
            int val;
            string reply = Call(CLASSNAME, "ReadReg", addr.ToString("X2"));
            int.TryParse(reply, NumberStyles.HexNumber, CultureInfo.CurrentCulture, out val);
            return val;
            //return GetReturnValue_Byte();
        }

        public void WriteReg(byte addr, int data)
        {
            Call(CLASSNAME, "WriteReg", addr.ToString("X2"), data.ToString("X2"));
        }
        public void StartConv()
        {
            Call(CLASSNAME, "StartConv");
        }

        private void InitStreaming()
        {
            client.pipeline.Discard();
            client.streaming.Init(client.pipeline);
            client.streaming.Start();
            //Call(CLASSNAME, "StreamTest");
            //CallNoReply(CLASSNAME, "StreamTest");
        }


        public int Rbias_FMSTR_Init(
            int En_rbias,
            int Rbiasv,
            int Rbiasp,
            int Rbiasn,
            int Fmstr)
        {
            Call(CLASSNAME, "Rbias_FMSTR_Init", En_rbias.ToString("X2"), Rbiasv.ToString("X2"), Rbiasp.ToString("X2"), Rbiasn.ToString("X2"), Fmstr.ToString("X2"));
            return 0;
        }


        // old 12/15/15 for reference
/*
                        public int CAL_InitStart(
                            int Vmode,
                            int Vmag,
                            int Fcal,
                            int Thigh,
                            int Fifty,
                            int En_Vcal)
                        {
                            Call(CLASSNAME, "CAL_InitStart", Vmode.ToString("X2"), Vmag.ToString("X2"), Fcal.ToString("X2"), Thigh.ToString("X2"), Fifty.ToString("X2"), En_Vcal.ToString("X2"));
                            return 0;
                        }

        */
        public int CAL_InitStart(
            int En_Vcal,
            int Vmode,
            int Vmag,
            int Fcal,
            int Thigh,
            int Fifty
            )
        {
            Call(CLASSNAME, "CAL_InitStart", En_Vcal.ToString("X2"), Vmode.ToString("X2"), Vmag.ToString("X2"), Fcal.ToString("X2"), Thigh.ToString("X2"), Fifty.ToString("X2"));
            return 0;
        }


        // old 12/15/15 for reference
/*        public int ECG_InitStart(
            int Openp,
            int Openn,
            int Pol,
            int Calp_sel,
            int Caln_sel,
            int En_ecg,
            int E_fit,
            int Clr_rrint,
            int Rate,
            int Gain,
            int Dhpf,
            int Dlpf)
        {
            Call(CLASSNAME, "ECG_InitStart", Openp.ToString("X2"), Openn.ToString("X2"), Pol.ToString("X2"), Calp_sel.ToString("X2"), Caln_sel.ToString("X2"), En_ecg.ToString("X2"), E_fit.ToString("X2"), Clr_rrint.ToString("X2"), Rate.ToString("X2"), Gain.ToString("X2"), Dhpf.ToString("X2"), Dlpf.ToString("X2"));
            return 0;
        }*/
        public int ECG_InitStart(
            int En_ecg,
            int Openp,
            int Openn,
            int Pol,
            int Calp_sel,
            int Caln_sel,
            int E_fit,
            int Rate,
            int Gain,
            int Dhpf,
            int Dlpf)
        {
            Call(CLASSNAME, "ECG_InitStart", En_ecg.ToString("X2"), Openp.ToString("X2"), Openn.ToString("X2"), Pol.ToString("X2"), Calp_sel.ToString("X2"), Caln_sel.ToString("X2"), 
                E_fit.ToString("X2"), Rate.ToString("X2"), Gain.ToString("X2"), Dhpf.ToString("X2"), Dlpf.ToString("X2"));
            return 0;
        }


        public int ECGFast_Init(
            int Clr_Fast,
            int Fast,
            int Fast_Th)
        {
            Call(CLASSNAME, "ECGFast_Init", Clr_Fast.ToString("X2"), Fast.ToString("X2"), Fast_Th.ToString("X2"));
            return 0;
        }

        public int PACE_InitStart(
            int En_pace,
            int Clr_pedge,
            int Pol,
            int Gn_diff_off,
            int Gain,
            int Aout_lbw,
            int Aout,
            int Dacp,
            int Dacn)
        {
            Call(CLASSNAME, "PACE_InitStart", En_pace.ToString("X2"), Clr_pedge.ToString("X2"), Pol.ToString("X2"), Gn_diff_off.ToString("X2"), Gain.ToString("X2"), Aout_lbw.ToString("X2"), Aout.ToString("X2"), Dacp.ToString("X2"), Dacn.ToString("X2"));
            return 0;
        }

        // old 12/15/15 for reference
/*        public int BIOZ_InitStart(
                    int Openp,
                    int Openn,
                    int Calp_sel,
                    int Caln_sel,
                    int CG_mode,
                    int En_bioz,
                    int B_fit,
                    int Rate,
                    int Ahpf,
                    int Ext_rbias,
                    int Gain,
                    int Dhpf,
                    int Dlpf,
                    int Fcgen,
                    int Cgmon,
                    int Cgmag,
                    int Phoff)
                {
                    Call(CLASSNAME, "BIOZ_InitStart", Openp.ToString("X2"), Openn.ToString("X2"), Calp_sel.ToString("X2"), Caln_sel.ToString("X2"), CG_mode.ToString("X2"),
                        En_bioz.ToString("X2"), B_fit.ToString("X2"), Rate.ToString("X2"), Ahpf.ToString("X2"), Ext_rbias.ToString("X2"), Gain.ToString("X2"),
                        Dhpf.ToString("X2"), Dlpf.ToString("X2"), Fcgen.ToString("X2"), Cgmon.ToString("X2"), Cgmag.ToString("X2"), Phoff.ToString("X2"));
                    return 0;
                }*/
        public int BIOZ_InitStart(
            int En_bioz,
            int Openp,
            int Openn,
            int Calp_sel,
            int Caln_sel,
            int CG_mode,
            int B_fit,
            int Rate,
            int Ahpf,
            int Ext_rbias,
            int Gain,
            int Dhpf,
            int Dlpf,
            int Fcgen,
            int Cgmon,
            int Cgmag,
            int Phoff)
        {
            Call(CLASSNAME, "BIOZ_InitStart", En_bioz.ToString("X2"), Openp.ToString("X2"), Openn.ToString("X2"), Calp_sel.ToString("X2"), Caln_sel.ToString("X2"), CG_mode.ToString("X2"),
                B_fit.ToString("X2"), Rate.ToString("X2"), Ahpf.ToString("X2"), Ext_rbias.ToString("X2"), Gain.ToString("X2"),
                Dhpf.ToString("X2"), Dlpf.ToString("X2"), Fcgen.ToString("X2"), Cgmon.ToString("X2"), Cgmag.ToString("X2"), Phoff.ToString("X2"));
            return 0;
        }

        // old 12/15/15 for reference
/*        public int RtoR_InitStart(
                    int Wndw,
                    int Gain,
                    int En_rtor,
                    int Pavg,
                    int Ptsf,
                    int Hoff,
                    int Ravg,
                    int Rhsf)
                {
                    Call(CLASSNAME, "RtoR_InitStart", Wndw.ToString("X2"), Gain.ToString("X2"), En_rtor.ToString("X2"), Pavg.ToString("X2"), Ptsf.ToString("X2"),
                        Hoff.ToString("X2"), Ravg.ToString("X2"), Rhsf.ToString("X2"));
                    return 0;
                }*/
        public int RtoR_InitStart(
            int En_rtor,
            int Wndw,
            int Gain,
            int Pavg,
            int Ptsf,
            int Hoff,
            int Ravg,
            int Rhsf,
            int Clr_rrint)
        {
            Call(CLASSNAME, "RtoR_InitStart", En_rtor.ToString("X2"), Wndw.ToString("X2"), Gain.ToString("X2"), Pavg.ToString("X2"), Ptsf.ToString("X2"),
                Hoff.ToString("X2"), Ravg.ToString("X2"), Rhsf.ToString("X2"), Clr_rrint.ToString("X2"));
            return 0;
        }

        public int Stop_ECG()
        {
            Call(CLASSNAME, "Stop_ECG");
            return 0;
        }

        public int Stop_PACE()
        {
            Call(CLASSNAME, "Stop_PACE");
            return 0;
        }

        public int Stop_Cal()
        {
            //Call(CLASSNAME, "Stop_Cal");
            return 0;
        }

        public int Stop_BIOZ()
        {
            Call(CLASSNAME, "Stop_BIOZ");
            return 0;
        }

        public int Stop_RtoR()
        {
            Call(CLASSNAME, "Stop_RtoR");
            return 0;
        }

        public void StartStreaming()
        {
            client.pipeline.Discard();
            InitStreaming();
            CallNoReply(CLASSNAME, "Start");
            //Call(CLASSNAME, "StartTest");
        }

        public void StartTest()
        {
            client.pipeline.Discard();
            InitStreaming();
            CallNoReply(CLASSNAME, "StartTest");
            //Call(CLASSNAME, "StartTest");
        }

        public void StopStreaming()
        {
            StopStreaming(true);                
        }

        public void StopStreaming(bool connected)
        {
            if (connected)
                client.pipeline.SendSingleByte(' ');

            client.streaming.Stop();

            if (connected)
            {
                client.pipeline.Discard();
                Thread.Sleep(500);
                client.pipeline.Discard();
            }
        }

        public void INT_assignment(
            max30001_intrpt_Location max30001_intrpt_Location, max30001_intrpt_Location max30001_intrpt_Location_2, max30001_intrpt_Location max30001_intrpt_Location_3, 
            max30001_intrpt_Location max30001_intrpt_Location_4, max30001_intrpt_Location max30001_intrpt_Location_5, max30001_intrpt_Location max30001_intrpt_Location_6, 
            max30001_intrpt_Location max30001_intrpt_Location_7, max30001_intrpt_Location max30001_intrpt_Location_8, max30001_intrpt_Location max30001_intrpt_Location_9, 
            max30001_intrpt_Location max30001_intrpt_Location_10, max30001_intrpt_Location max30001_intrpt_Location_11, max30001_intrpt_Location max30001_intrpt_Location_12, 
            max30001_intrpt_Location max30001_intrpt_Location_13, max30001_intrpt_Location max30001_intrpt_Location_14, max30001_intrpt_Location max30001_intrpt_Location_15, 
            max30001_intrpt_type max30001_intrpt_type, max30001_intrpt_type max30001_intrpt_type_2)
        {
            Call(CLASSNAME, "INT_assignment",
                max30001_intrpt_Location.ToString("x") , max30001_intrpt_Location_2.ToString("x") , max30001_intrpt_Location_3.ToString("x") ,
                max30001_intrpt_Location_4.ToString("x") , max30001_intrpt_Location_5.ToString("x") , max30001_intrpt_Location_6.ToString("x") ,
                max30001_intrpt_Location_7.ToString("x") , max30001_intrpt_Location_8.ToString("x") , max30001_intrpt_Location_9.ToString("x") ,
                max30001_intrpt_Location_10.ToString("x") , max30001_intrpt_Location_11.ToString("x") , max30001_intrpt_Location_12.ToString("x") ,
                max30001_intrpt_Location_13.ToString("x") , max30001_intrpt_Location_14.ToString("x") , max30001_intrpt_Location_15.ToString("x") ,
                max30001_intrpt_type.ToString("x") , max30001_intrpt_type_2.ToString("x") 
                );
        }
    }
}

    

