﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Maxim.Charting
{
    interface IAutoScaleAxisCalculator
    {
        /// <summary>
        /// Maximum possible data point
        /// </summary>
        double Maximum { get; set; }
        /// <summary>
        /// Minimum possible data point
        /// </summary>
        double Minimum { get; set; }

        /// <summary>
        /// Number of y-axis chart interval grid lines
        /// </summary>
        int Intervals { get; set; }

        /// <summary>
        /// Previous maximum interval result
        /// </summary>
        double LastMaximum { get; }
        /// <summary>
        /// Previous minimum interval result
        /// </summary>
        double LastMinimum { get; }

        /// <summary>
        /// Full scale range should be larger than this value
        /// </summary>
        double MinimumRange { get; set; }

        /// <summary>
        /// Trigger rescale value when data exceeds fraction of full scale. For example, a value of 0.8 will rescale on 10% (0.5 - 0.8/2) and 90% (0.5 + 0.8/2) of full scale.
        /// </summary>
        double ScaleTrigger { get; set; }

        /// <summary>
        /// Rescale data to be within a certain fraction of full scale. For example, a value of 0.25 will rescale so that the data minimum and maximum occupy 25% of the full scale.
        /// </summary>
        double RescaleTargetRange { get; set; }

        /// <summary>
        /// Calculate the round axis minimum and maximum value. Maximum range needs to be larger than 1 for this to function.
        /// </summary>
        /// <param name="dataMinimum">minimum value of data set</param>
        /// <param name="dataMaximum">maximum value of data set</param>
        /// <returns>minimum value, maximum value</returns>
        Tuple<double, double> Interval(double dataMinimum, double dataMaximum);
        
        /// <summary>
        /// Calculate the round axis minimum and maximum value. Maximum range needs to be larger than 1 for this to function.
        /// </summary>
        /// <param name="dataMinimum">minimum value of data set</param>
        /// <param name="dataMaximum">maximum value of data set</param>
        /// <param name="chartMinimum">minimum value of current chart</param>
        /// <param name="chartMaximum">maximum value of current chart</param>
        /// <returns>minimum value, maximum value</returns>
        Tuple<double, double> Interval(double dataMinimum, double dataMaximum, double chartMinimum, double chartMaximum);
    }
}
