﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using NUnit.Framework;
using HealthSensorPlatform.CustomControls;
using HealthSensorPlatform.Presenter;

namespace EcgViewTest
{
    class RToRTest
    {
        [TestCase(8746, 0)]
        [TestCase(9002, 1)]
        [TestCase(12586, 15)]
        public void RToRDetectionDelay(int expect, int rToRWndw)
        {
            EcgView view = new EcgView();

            view.RToRWindowField = rToRWndw;

            Assert.AreEqual(expect, view.RToRDelay);
        }

        [TestCase(650, 0, 0, 0)]
        [TestCase(1034, 0, 0, 1)]
        [TestCase(1034, 0, 0, 2)]
        [TestCase(1034, 0, 0, 3)]
        [TestCase(2922, 0, 1, 0)]
        [TestCase(3370, 0, 2, 0)]
        [TestCase(3370, 0, 3, 0)]
        [TestCase(1242, 2, 2, 0)]
        [TestCase(1242, 3, 2, 0)]
        [TestCase(1242, 3, 3, 0)]
        [TestCase(2202, 3, 3, 1)]
        public void EcgDecimationDelay(int expect, int masterClock, int rate, int lpf)
        {
            EcgView view = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgInit.Rate = rate;
            ecgInit.Dlpf = lpf;

            view.ecgArgs = ecgInit;
            view.FrequencyMasterField = masterClock;

            Assert.AreEqual(expect, view.EcgDecimationDelay);
        }

        /*
        [TestCase(100, 118)]
        public void RToRToEcgPoints(int expect, int rToR)
        {
            EcgView view = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgInit.Rate = 3;
            ecgInit.Dlpf = 1;

            view.ecgArgs = ecgInit;
            view.FrequencyMasterField = 0;
            view.RToRWindowField = 3;

            Assert.AreEqual(expect, view.RToREcgPoints(rToR, true));
        }

        [TestCase(205, 128, 1)]
        [TestCase(205, 128, 2)]
        [TestCase(204, 128, 3)]
        [TestCase(205, 128, 4)]
        [TestCase(205, 128, 5)]
        [TestCase(205, 128, 6)]
        [TestCase(205, 128, 7)]
        [TestCase(204, 128, 8)]
        [TestCase(205, 128, 9)]
        [TestCase(205, 128, 10)]
        [TestCase(205, 128, 11)]
        [TestCase(205, 128, 12)]
        [TestCase(204, 128, 13)]
        public void RToREcgPointRoundingLoop(int expect, int rToR, int loop)
        {
            int result = 0;

            EcgView view = new EcgView();
            InitArgs.EcgInitStart ecgInit = new InitArgs.EcgInitStart();

            ecgInit.Rate = 3;
            ecgInit.Dlpf = 1;

            view.SampleRateECG = 199.8;

            view.ecgArgs = ecgInit;
            view.FrequencyMasterField = 3;

            for (int i = 0; i < loop; i++)
            {
                result = view.RToREcgPoints(rToR, false);
            }

            Assert.AreEqual(expect, result);
        }
         * */

        [TestCase(205, 128, 1)]
        [TestCase(205, 128, 2)]
        [TestCase(204, 128, 3)]
        [TestCase(205, 128, 4)]
        [TestCase(205, 128, 5)]
        [TestCase(205, 128, 6)]
        [TestCase(205, 128, 7)]
        [TestCase(204, 128, 8)]
        [TestCase(205, 128, 9)]
        [TestCase(205, 128, 10)]
        [TestCase(205, 128, 11)]
        [TestCase(205, 128, 12)]
        [TestCase(204, 128, 13)]
        public void RToRCalculatorRoundingLoop(int expect, int rToR, int loop)
        {
            int result = 0;

            RToRCalculator rToRCalculator = new RToRCalculator(3, 3, 1, 0);

            for (int i = 0; i < loop; i++)
            {
                result = rToRCalculator.EcgPoints(rToR, false);
            }

            Assert.AreEqual(expect, result);
        }
    }
}
