﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using NUnit.Framework;
using HealthSensorPlatform.CustomControls;
using HealthSensorPlatform.Model;
using RPCSupport.Streaming;
using System.Windows.Forms;

namespace EcgViewTest
{
    [TestFixture]
    public partial class EcgTest
    {
        /*
        [Test]
        public void PaceDataTag0()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                0, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                0 << 14 | 0 << 13 | 0 << 12 | 1 << 2 | 1 << 1 | 1, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456
            };

            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-1, result.PaceLength(0));
        }

        [Test]
        public void PaceDataTag1()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                1, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                123456, 123456, 123456, 
                0 << 14 | 0 << 13 | 0 << 12 | 1 << 2 | 1 << 1 | 1, 123456, 123456,
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456
            };

            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-1, result.PaceLength(1));
        }

        [Test]
        public void PaceDataTag2()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                2, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                0 << 14 | 0 << 13 | 0 << 12 | 1 << 2 | 1 << 1 | 1, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456
            };

            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-1, result.PaceLength(2));
        }

        [Test]
        public void PaceDataTag5()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                5, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456,
                0 << 14 | 0 << 13 | 0 << 12 | 1 << 2 | 1 << 1 | 1, 123456, 123456
            }; 

            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-1, result.PaceLength(5));
        }

        [Test]
        public void PaceDataTag5Last()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                5, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456,
                0 << 14 | 0 << 13 | 0 << 12 | 1 << 2 | 1 << 1 | 0, 0, 1 << 2 | 1 << 1 | 1
            };

            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-1, result.PaceLength(5));
        }

        [Test]
        public void PaceDataFalling()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                0, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                0 << 14 | 0 << 13 | 0 << 12 | 1 << 2 | 0 << 1 | 1, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456
            };


            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-1, result.PaceLength(0));
        }

        [Test]
        public void PaceDataRising()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                0, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                0 << 14 | 1 << 13 | 0 << 12 | 1 << 2 | 0 << 1 | 1, 123456, 123456, 
                //        Rising                      Falling
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456
            };


            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(1, result.PaceLength(0));
        }

        [Test]
        public void PaceDataMaxCode()
        {
            Form form = new Form();
            EcgView ecgView = new EcgView();
            PaceData result;
            PartialArrayIntAvailableEventArgs args = new PartialArrayIntAvailableEventArgs();
            PartialArrayIntAvailableEventArgs ecgArgs = new PartialArrayIntAvailableEventArgs();

            ecgArgs = new PartialArrayIntAvailableEventArgs();
            ecgArgs.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_ECG;
            args.sampleNumberOffset = 5;
            args.array1 = new int[] {
                7,
                7,
                0, // Tag 0 has pace data
                7,
                7
            };

            args.reportID = PartialArrayIntAvailableEventArgs.PACKET_MAX30001_PACE;
            args.sampleNumberOffset = 18;
            args.array1 = new int[] {
                0 << 14 | 0 << 13 | 0 << 12 | 0x3FF << 2 | 1 << 1 | 1, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456, 
                123456, 123456, 123456,
                123456, 123456, 123456,
                123456, 123456, 123456
            };


            form.Controls.Add(ecgView);
            ecgView.On_AppendChart(this, args);
            result = ecgView.paceData;

            Assert.AreEqual(-0x3FF, result.PaceLength(0));
        }
        */

        [Test]
        public void PaceDataParsing()
        {
            PaceData.PaceRegister register = new PaceData.PaceRegister(new int[] { 0x5865A6, 0x5E868C, 0x6E3FFF });

            Assert.AreEqual(353, register.Edge[0].Data);
            Assert.AreEqual(361, register.Edge[1].Data);
            Assert.AreEqual(378, register.Edge[2].Data);
            Assert.AreEqual(419, register.Edge[3].Data);
            Assert.AreEqual(440, register.Edge[4].Data);
        }
    }
}
