﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using NUnit.Framework;
using RPCSupport.Devices;
using RPCSupport.DeviceSupport;
using RPCSupport;

namespace RPCSupportTest
{
    [TestFixture]
    [Property("Class", "I2C")]
    public class I2cTest 
    {
        RPCClient rpcClient;
        I2cDevice i2cDevice;

        [TestFixtureSetUp]
        public void Init()
        {
            rpcClient = new RPCClient(RPCClient.ePipeline.eSerialWrap);
            rpcClient.InitPipeline();
            rpcClient.Connect(ComPort.Port);
            i2cDevice = rpcClient.Init_I2cDevice();
        }

        [TestFixtureTearDown]
        public void Dispose()
        {
            rpcClient.Disconnect();
        }
        
        [Test]
        public void I2CRead()
        {
            byte result = i2cDevice.ReadReg(1, 0x90, 0x01);

            Assert.AreEqual(true, result >= 0 && result <= 0xff);
        }

        [Test]
        public void I2CWriteConfigurationRegister()
        {
            /*
            byte data = max30205.ReadReg(0x01);

            byte flipped = (byte)(data ^ 0xFF);

            max30205.WriteReg(0x01, flipped);

            byte result = max30205.ReadReg(0x01);

            max30205.WriteReg(0x01, data); // Restore register value

            Assert.AreEqual(flipped, result);
            */
            byte data = i2cDevice.ReadReg(1, 0x90, 0x01);

            byte flipped = (byte)(data & 0xFF);

            i2cDevice.WriteReg(1, 0x90, 0x01, flipped);

            byte result = i2cDevice.ReadReg(1, 0x90, 0x01);

            i2cDevice.WriteReg(1, 0x90, 0x01, data);

            Assert.AreEqual(flipped, result);
        }

        [Test]
        public void I2CReadMultiple()
        {
            byte[] data = i2cDevice.ReadMultiReg(1, 0x90, 0x03, 2);

            Assert.True(data[0] == 0x50 && data[1] == 0x00);
            Assert.AreEqual(new byte[] { 0x50, 0x00 }, data);
        }

        [Test]
        public void I2CWriteMultiReg()
        {
            byte[] data = i2cDevice.ReadMultiReg(1, 0x90, 0x03, 2);

            i2cDevice.WriteMultiReg(1, 0x90, 0x03, 2, new byte[] { 0x12, 0x34 });
            byte[] result = i2cDevice.ReadMultiReg(1, 0x90, 0x03, 2);

            
            i2cDevice.WriteMultiReg(1, 0x90, 0x03, 2, data); // restore data

            Assert.AreEqual(new byte[] {0x12, 0x34}, result);

        }

        [Test]
        public void I2CReadRegDetails()
        {
            DeviceDetails details = new DeviceDetails();
            RegisterInfo reg = new RegisterInfo("CONFIG", 0x01);

            details.InitI2c(1, 0x90);

            i2cDevice.ReadReg(details, reg);

            Assert.True(reg.data[0] >= 0x00 && reg.data[0] <= 0xFF);
        }

        [Test]
        public void I2CReadMultipleDetails()
        {
            DeviceDetails details = new DeviceDetails();
            RegisterInfo reg = new RegisterInfo("OVERT", 0x03, 2, RegisterInfo.RegisterType.None);

            details.InitI2c(1, 0x90);

            i2cDevice.ReadReg(details, reg);

            Assert.True(reg.data[0] == 0x50 && reg.data[1] == 0x00);
            Assert.AreEqual(new byte[] { 0x50, 0x00 }, reg.data);
        }

        [Test]
        public void I2CWriteRead()
        {
            byte[] data = i2cDevice.WriteRead(1, 0x90, new byte[] { 0x03 }, 2);

            Assert.True(data[0] == 0x50 && data[1] == 0x00);
            Assert.AreEqual(new byte[] { 0x50, 0x00 }, data);
        }

    }
}