﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace HealthSensorPlatform.View.FileLogView
{
    class FileLogHeader
    {
        private string temperature1 = "Temperature 1 [15:0], Temperature (°C)";
        private string temperature2 = "Temperature 2 [15:0], Temperature (°C)";
        private string pressure = "Temperature, Temperature (°C), Pressure, Pressure (Pa)";
        private string ecg = "Time (s), ECG_DATA[17:0], ETAG[2:0], PTAG[2:0], ECG (mV), LDOFF_PH, LDOFF_PL, LDOFF_NH, LDOFF_NL";
        private string bioz = "Time (s), BIOZ_DATA[19:0], BTAG[2:0], BioZ (ohm), LDOFF_PH, LDOFF_PL, LDOFF_NH, LDOFF_NL, BOVER, BUNDR";
        private string rToR = "RTOR[13:0], R-To-R Corrected Time of R-peak (s)";
        private string pace = "Time (s), PACEn_mDATA[9:0], Rising/Falling, Last";
        private string optical = "Time (s), Red, IR (Infrared), Green";
        private string accelerometer = "Time (s), X-Axis, Y-Axis, Z-Axis";

        public string Prefix = "% ";

        public string Temperature1 { get { return Prefix + temperature1; } }
        public string Temperature2 { get { return Prefix + temperature2; } }
        public string Pressure { get { return Prefix + pressure; } }
        public string Ecg { get { return Prefix + ecg; } }
        public string BioZ { get { return Prefix + bioz; } }
        public string RToR { get { return Prefix + rToR; } }
        public string Pace { get { return Prefix + pace; } }
        public string Optical { get { return Prefix + optical; } }
        public string Accelerometer { get { return Prefix + accelerometer; } }
    }
}
