﻿/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All rights Reserved.
* 
* This software is protected by copyright laws of the United States and
* of foreign countries. This material may also be protected by patent laws
* and technology transfer regulations of the United States and of foreign
* countries. This software is furnished under a license agreement and/or a
* nondisclosure agreement and may only be used or reproduced in accordance
* with the terms of those agreements. Dissemination of this information to
* any party or parties not specified in the license agreement and/or
* nondisclosure agreement is expressly prohibited.
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

//------------------------------------------------------------------------------------------
// OS24EVK-59 split into HeartRateApp EXE and MAX30101 DLL.
// Moved all MAX30101 DLL classes into namespace Maxim.MAX30101GUI
// Moved all HeartRateApp GUI classes into namespace Maxim.MAX30101
// OS24EVK-59 Create separate project that builds Maxim.MAX30101GUI DLL library

namespace HealthSensorPlatform
{
    public partial class SplashScreen : Form
    {
        private Timer timer = new Timer();
        internal bool EnableTimer = true;


        public SplashScreen()
        {
            InitializeComponent();

            //create event handler for timer event
            maximSplashScreen1.ConfigureTimer(timer, new EventHandler(timer_Tick));

            //create event handlers for the links and disable checkbox
            maximSplashScreen1.LinkClicked += new LinkLabelLinkClickedEventHandler(LinkClicked);
            maximSplashScreen1.DisableSplashScreenClicked += new EventHandler(DisableSplashScreenClicked);
        }

        public SplashScreen(int numberOfSeconds)
        {
            InitializeComponent();

            maximSplashScreen1.DismissTime = numberOfSeconds;

            //create event handler for timer event
            maximSplashScreen1.ConfigureTimer(timer, new EventHandler(timer_Tick));

            //create event handlers for the links and disable checkbox
            maximSplashScreen1.LinkClicked += new LinkLabelLinkClickedEventHandler(LinkClicked);
            maximSplashScreen1.DisableSplashScreenClicked += new EventHandler(DisableSplashScreenClicked);
        }

        public bool SplashDisabled()
        {
            return Properties.Settings.Default.DisableSplash;
        }

        public void ShowOKButton()
        {
            btn_OK.Visible = true;
        }

        private void SplashScreen_Load(object sender, EventArgs e)
        {
            if (EnableTimer)//start timer if enabled
                timer.Start();
            else
                timer.Stop();

            if (Properties.Settings.Default.DisableSplash == true)
                maximSplashScreen1.Checked = true;
        }
        void timer_Tick(object sender, EventArgs e)
        {
            //stop timer and close splash screen when time is up
            timer.Stop();
            this.Hide();
        }

        void LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            //get the linkLabel that was clicked
            LinkLabel linkLabel = (LinkLabel)sender;

            //linkLabel.LinkVisited = true;

            //Launch link in browser
            System.Diagnostics.Process.Start("http://" + linkLabel.Text);
        }

        void DisableSplashScreenClicked(object sender, EventArgs e)
        {
            //get the checkbox that was clicked
            CheckBox checkBox = (CheckBox)sender;

            //save the checked status in the app settings
            Properties.Settings.Default.DisableSplash = checkBox.Checked;
            Properties.Settings.Default.Save();
        }

        private void btn_OK_Click(object sender, EventArgs e)
        {
            this.Hide();
        }
    }
}
